/*
 * Decompiled with CFR 0.152.
 */
package mapchecker;

import com.jtechlabs.ui.widget.directorychooser.JDirectoryChooser;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mapchecker.RunChecks;

public class Mapchecker
extends JFrame {
    private JTextField topLevel;
    private JTextField logText;
    private JTextField mapText;
    private JCheckBox ignoreMissingFloors;
    private JButton buttonBrowse;
    private JButton buttonCheck;
    private JButton buttonExit;
    private JTextArea progressText;
    private JScrollPane progressScroll;
    private int browseResult;
    private String topLevelDir;
    private String mapRootDir;
    private int mapRootLen = 0;
    private String logPath;
    private String archRoot;
    private File mapFile;
    private File logFile;
    private File archFile;
    private File artFile;
    private RunChecks checker;
    private boolean mapFileSet = false;
    private boolean logFileSet = false;
    private boolean commandLine = false;
    final String version = "V1.8";

    public static void main(String[] args) {
        String topDirStr = new String("");
        String logFileStr = new String("");
        if (args.length > 0) {
            topDirStr = args[0];
            if (args.length > 1) {
                logFileStr = args[1];
            } else {
                System.out.println("Usage: java -jar mapchecker.jar top_level_directory log_file_path");
                System.exit(0);
            }
        }
        new Mapchecker(topDirStr, logFileStr);
    }

    public Mapchecker(String topDirStr, String logFileStr) {
        this.topLevelDir = topDirStr;
        this.logPath = logFileStr;
        if (this.topLevelDir.length() > 0 && this.logPath.length() > 0) {
            this.commandLine = true;
            this.mapFile = new File(this.topLevelDir);
            this.logFile = new File(this.logPath);
            if (this.checkMapPath()) {
                this.checker = new RunChecks(this.mapFile, this.logFile, this.mapRootDir, this.mapRootLen, this.archRoot, null, null, false, "V1.8");
                this.checker.start();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                while (this.checker.getActive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            System.exit(0);
        } else {
            this.setSize(350, 400);
            this.setDefaultCloseOperation(0);
            this.setTitle("Daimonin Map Checker V1.8");
            TBrowseListener tbl = new TBrowseListener();
            LBrowseListener lbl = new LBrowseListener();
            TopLevelListener tldl = new TopLevelListener();
            LogTextListener ltdl = new LogTextListener();
            CheckListener cl = new CheckListener();
            ExitListener el = new ExitListener();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    Mapchecker.this.buttonExit.doClick();
                }
            });
            Box box0 = Box.createVerticalBox();
            Box box1 = Box.createHorizontalBox();
            Box box2 = Box.createHorizontalBox();
            Box box3 = Box.createHorizontalBox();
            Box box4 = Box.createHorizontalBox();
            Box box5 = Box.createHorizontalBox();
            Box box6 = Box.createHorizontalBox();
            Box box7 = Box.createHorizontalBox();
            box0.add(Box.createVerticalStrut(20));
            box1.add(Box.createHorizontalStrut(10));
            box1.add(new JLabel("Check:   "));
            box1.add(Box.createHorizontalGlue());
            this.topLevel = new JTextField(32);
            this.topLevel.setMaximumSize(new Dimension(300, 25));
            this.topLevel.getDocument().addDocumentListener(tldl);
            box1.add(this.topLevel);
            box1.add(Box.createHorizontalStrut(10));
            this.buttonBrowse = new JButton("...");
            this.buttonBrowse.addActionListener(tbl);
            box1.add(this.buttonBrowse);
            box1.add(Box.createHorizontalStrut(10));
            box2.add(Box.createHorizontalStrut(10));
            box2.add(new JLabel("Log file: "));
            box2.add(Box.createHorizontalGlue());
            this.logText = new JTextField(32);
            this.logText.setMaximumSize(new Dimension(300, 25));
            this.logText.getDocument().addDocumentListener(ltdl);
            box2.add(this.logText);
            box2.add(Box.createHorizontalStrut(10));
            this.buttonBrowse = new JButton("...");
            this.buttonBrowse.addActionListener(lbl);
            box2.add(this.buttonBrowse);
            box2.add(Box.createHorizontalStrut(10));
            box3.add(Box.createHorizontalStrut(10));
            box3.add(new JLabel("Map: "));
            box3.add(Box.createHorizontalGlue());
            this.mapText = new JTextField(32);
            this.mapText.setMaximumSize(new Dimension(300, 25));
            box3.add(this.mapText);
            box3.add(Box.createHorizontalStrut(10));
            box4.add(Box.createHorizontalStrut(10));
            box4.add(new JLabel("Progress:"));
            box4.add(Box.createHorizontalGlue());
            this.progressText = new JTextArea(10, 20);
            this.progressText.setEditable(false);
            this.progressScroll = new JScrollPane(this.progressText, 20, 30);
            box5.add(Box.createHorizontalStrut(10));
            box5.add(this.progressScroll);
            box5.add(Box.createHorizontalStrut(10));
            this.ignoreMissingFloors = new JCheckBox("Ignore missing floors");
            box6.add(this.ignoreMissingFloors);
            this.buttonExit = new JButton("Exit");
            this.buttonExit.addActionListener(el);
            this.buttonCheck = new JButton("Check Maps");
            this.buttonCheck.addActionListener(cl);
            this.buttonCheck.setEnabled(false);
            box7.add(Box.createHorizontalStrut(60));
            box7.add(this.buttonCheck);
            box7.add(Box.createHorizontalGlue());
            box7.add(this.buttonExit);
            box7.add(Box.createHorizontalStrut(10));
            box0.add(box1);
            box0.add(Box.createVerticalStrut(10));
            box0.add(box2);
            box0.add(Box.createVerticalStrut(10));
            box0.add(box3);
            box0.add(Box.createVerticalStrut(10));
            box0.add(box4);
            box0.add(Box.createVerticalStrut(10));
            box0.add(box5);
            box0.add(Box.createVerticalStrut(10));
            box0.add(box6);
            box0.add(Box.createVerticalStrut(10));
            box0.add(Box.createVerticalGlue());
            box0.add(box7);
            box0.add(Box.createVerticalStrut(10));
            this.add(box0);
            this.setResizable(false);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.progressText.append("Browse for directory at head of map tree to be checked\r\nin 'Check' window, then browse for log file name in\r\n'Log file' window.\r\n\r\nYou can check from top-level /maps directory\r\nor from any directory below this.\r\n\r\nWhen these are set, click on 'Check Maps' button.\r\n\r\n");
        }
    }

    private boolean checkMapPath() {
        boolean valid = false;
        int pos = -1;
        if (this.topLevelDir.matches(".+[\\\\/]$")) {
            this.topLevelDir = this.topLevelDir.substring(0, this.topLevelDir.length() - 1);
            this.topLevel.setText(this.topLevelDir);
        }
        if (this.topLevelDir.matches(".+[\\\\/]maps$")) {
            this.mapRootDir = this.topLevelDir;
            valid = true;
        } else if (this.topLevelDir.matches(".+[\\\\/]maps[\\\\/]{1}.+")) {
            pos = this.topLevelDir.indexOf("/maps/");
            if (pos == -1) {
                pos = this.topLevelDir.indexOf("\\maps\\");
            }
            assert (pos >= 0);
            this.mapRootDir = this.topLevelDir.substring(0, pos + 5);
            valid = true;
        }
        if (!valid) {
            this.reportError("Map path must contain 'maps' directory");
        } else {
            this.mapRootLen = this.mapRootDir.length();
            this.archRoot = this.mapRootDir.substring(0, this.mapRootLen - 5) + File.separator + "arch" + File.separator;
            String s2 = this.archRoot + "archetypes";
            this.archFile = new File(s2);
            if (!this.archFile.exists()) {
                this.reportError("Can't find archetypes file " + s2);
                valid = false;
            }
            s2 = this.archRoot + "artifacts";
            this.artFile = new File(s2);
            if (!this.artFile.exists()) {
                this.reportError("Can't find artifacts file " + s2);
                valid = false;
            }
        }
        return valid;
    }

    private void reportError(String s2) {
        if (this.commandLine) {
            System.out.println(s2);
        } else {
            JOptionPane.showMessageDialog(null, s2);
        }
    }

    private class ExitListener
    implements ActionListener {
        private ExitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean allowExit = false;
            if (Mapchecker.this.checker != null && Mapchecker.this.checker.getActive()) {
                if (JOptionPane.showConfirmDialog(null, "This will terminate the active check.\nAre you sure?", "Exit", 0, 3) == 0 && Mapchecker.this.checker.Shutdown()) {
                    allowExit = true;
                }
            } else {
                allowExit = true;
            }
            if (allowExit) {
                System.exit(0);
            }
        }
    }

    private class CheckListener
    implements ActionListener {
        private CheckListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean ok = true;
            Mapchecker.this.buttonCheck.setEnabled(false);
            if (Mapchecker.this.checkMapPath()) {
                Mapchecker.this.mapFile = new File(Mapchecker.this.topLevelDir);
                Mapchecker.this.logFile = new File(Mapchecker.this.logPath);
                if (Mapchecker.this.logFile.isDirectory()) {
                    Mapchecker.this.reportError("Log file is a directory");
                    ok = false;
                } else if (Mapchecker.this.logFile.exists()) {
                    boolean bl = ok = JOptionPane.showConfirmDialog(null, "Log file already exists: do you want to overwrite it?", "File exists", 0, 3) == 0;
                    if (ok) {
                        Mapchecker.this.logFile.delete();
                    }
                }
                if (ok) {
                    boolean ignore = Mapchecker.this.ignoreMissingFloors.isSelected();
                    Mapchecker.this.checker = new RunChecks(Mapchecker.this.mapFile, Mapchecker.this.logFile, Mapchecker.this.mapRootDir, Mapchecker.this.mapRootLen, Mapchecker.this.archRoot, Mapchecker.this.mapText, Mapchecker.this.progressText, ignore, "V1.8");
                    Mapchecker.this.checker.start();
                }
            }
        }
    }

    private class LogTextListener
    implements DocumentListener {
        private LogTextListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            Mapchecker.this.logFileSet = true;
            Mapchecker.this.logPath = Mapchecker.this.logText.getText();
            if (Mapchecker.this.mapFileSet) {
                Mapchecker.this.buttonCheck.setEnabled(true);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (Mapchecker.this.logText.getDocument().getLength() == 0) {
                Mapchecker.this.logFileSet = false;
                Mapchecker.this.buttonCheck.setEnabled(false);
            } else {
                Mapchecker.this.logFileSet = true;
                Mapchecker.this.logPath = Mapchecker.this.logText.getText();
                if (Mapchecker.this.mapFileSet) {
                    Mapchecker.this.buttonCheck.setEnabled(true);
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (Mapchecker.this.logText.getDocument().getLength() == 0) {
                Mapchecker.this.logFileSet = false;
                Mapchecker.this.buttonCheck.setEnabled(false);
            } else {
                Mapchecker.this.logFileSet = true;
                Mapchecker.this.logPath = Mapchecker.this.logText.getText();
                if (Mapchecker.this.mapFileSet) {
                    Mapchecker.this.buttonCheck.setEnabled(true);
                }
            }
        }
    }

    private class LBrowseListener
    implements ActionListener {
        private LBrowseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("Select log file");
            fc.setApproveButtonText("Select");
            int result = fc.showSaveDialog(null);
            if (result == 0) {
                File temp = new File("");
                temp = fc.getSelectedFile();
                Mapchecker.this.logPath = temp.getPath();
                Mapchecker.this.logText.setText(Mapchecker.this.logPath);
                Mapchecker.this.logFileSet = true;
                if (Mapchecker.this.mapFileSet) {
                    Mapchecker.this.buttonCheck.setEnabled(true);
                }
            }
        }
    }

    private class TopLevelListener
    implements DocumentListener {
        private TopLevelListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            Mapchecker.this.topLevelDir = Mapchecker.this.topLevel.getText();
            Mapchecker.this.mapFileSet = true;
            if (Mapchecker.this.logFileSet) {
                Mapchecker.this.buttonCheck.setEnabled(true);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            boolean tf = true;
            Mapchecker.this.topLevelDir = Mapchecker.this.topLevel.getText();
            if (Mapchecker.this.topLevel.getDocument().getLength() == 0) {
                tf = false;
            }
            Mapchecker.this.mapFileSet = tf;
            Mapchecker.this.buttonCheck.setEnabled(tf);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            boolean tf = true;
            Mapchecker.this.topLevelDir = Mapchecker.this.topLevel.getText();
            if (Mapchecker.this.topLevel.getDocument().getLength() == 0) {
                tf = false;
            }
            Mapchecker.this.mapFileSet = tf;
            Mapchecker.this.buttonCheck.setEnabled(tf);
        }
    }

    private class TBrowseListener
    implements ActionListener {
        private TBrowseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            File f2 = JDirectoryChooser.showDialog(null, null, "Select folder", "Choose top-level map directory", 0);
            if (f2 != null) {
                Mapchecker.this.topLevelDir = f2.getPath();
                Mapchecker.this.topLevel.setText(Mapchecker.this.topLevelDir);
                Mapchecker.this.mapFileSet = true;
                if (Mapchecker.this.logFileSet) {
                    Mapchecker.this.buttonCheck.setEnabled(true);
                }
            }
        }
    }
}

