/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.metadata;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.gradle.internal.Pair;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetadata;
import org.gradle.platform.base.internal.toolchain.ComponentFound;
import org.gradle.platform.base.internal.toolchain.ComponentNotFound;
import org.gradle.platform.base.internal.toolchain.SearchResult;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;

public abstract class AbstractMetadataProvider<T extends CompilerMetadata>
implements CompilerMetaDataProvider<T> {
    private final ExecActionFactory execActionFactory;

    public AbstractMetadataProvider(ExecActionFactory execActionFactory) {
        this.execActionFactory = execActionFactory;
    }

    @Override
    public SearchResult<T> getCompilerMetaData(File binary, List<String> additionalArgs) {
        ImmutableList allArgs = ImmutableList.builder().addAll(additionalArgs).addAll(this.compilerArgs()).build();
        Pair<String, String> transform = this.runCompiler(binary, (List<String>)allArgs);
        if (transform == null) {
            return new ComponentNotFound(String.format("Could not determine %s metadata: failed to execute %s %s.", this.getCompilerType().getDescription(), binary.getName(), Joiner.on((char)' ').join((Iterable)allArgs)));
        }
        String output = (String)transform.getLeft();
        String error = (String)transform.getRight();
        try {
            return new ComponentFound(this.parseCompilerOutput(output, error, binary));
        }
        catch (BrokenResultException e) {
            return new ComponentNotFound(e.getMessage());
        }
    }

    protected abstract T parseCompilerOutput(String var1, String var2, File var3) throws BrokenResultException;

    private Pair<String, String> runCompiler(File gccBinary, List<String> args) {
        ExecAction exec = this.execActionFactory.newExecAction();
        exec.executable((Object)gccBinary.getAbsolutePath());
        exec.setWorkingDir(gccBinary.getParentFile());
        exec.args(args);
        StreamByteBuffer buffer = new StreamByteBuffer();
        StreamByteBuffer errorBuffer = new StreamByteBuffer();
        exec.setStandardOutput(buffer.getOutputStream());
        exec.setErrorOutput(errorBuffer.getOutputStream());
        exec.setIgnoreExitValue(true);
        ExecResult result = exec.execute();
        int exitValue = result.getExitValue();
        if (exitValue == 0) {
            return Pair.of((Object)buffer.readAsString(), (Object)errorBuffer.readAsString());
        }
        return null;
    }

    protected abstract List<String> compilerArgs();

    public static class BrokenResultException
    extends RuntimeException {
        public BrokenResultException(String message) {
            super(message);
        }
    }
}

