/**
 * Windows API header module
 *
 * Translated from MinGW Windows headers
 *
 * Authors: Vladimir Vlasov
 * License: $(LINK2 http://www.boost.org/LICENSE_1_0.txt, Boost License 1.0)
 * Source: $(DRUNTIMESRC core/sys/windows/_setupapi.d)
 */
module core.sys.windows.setupapi;
version (Windows):
@system:

version (ANSI) {} else version = Unicode;
pragma(lib, "setupapi");

import core.sys.windows.basetyps, core.sys.windows.commctrl, core.sys.windows.prsht, core.sys.windows.w32api,
  core.sys.windows.winreg, core.sys.windows.windef;
import core.sys.windows.winbase; // for SYSTEMTIME

/*static if (_WIN32_WINNT < _WIN32_WINDOWS) {
enum UINT _SETUPAPI_VER = _WIN32_WINNT; // SetupAPI version follows Windows NT version
} else static if (_WIN32_WINDOWS) {
    static if (_WIN32_WINDOWS >= 0x0490) {
enum UINT _SETUPAPI_VER = 0x0500;     // WinME uses same version of SetupAPI as Win2k
    } else static if (_WIN32_WINDOWS >= 0x0410) {
enum UINT _SETUPAPI_VER = 0x0410;     // Indicates version of SetupAPI shipped with Win98
    } else {
enum UINT _SETUPAPI_VER = 0x0400;     // Earliest SetupAPI version
    }
} else {
enum UINT _SETUPAPI_VER = 0x0501;
}

version (WindowsNTonly) {
    static if (_WIN32_WINNT >= 0x500) {
enum UINT USE_SP_DRVINFO_DATA_V1 = 0;
    } else {
enum UINT USE_SP_DRVINFO_DATA_V1 = 1;
    }
} else {
enum UINT USE_SP_DRVINFO_DATA_V1 = 1;
}*/
/+
enum UINT _SETUPAPI_VER = 0x0400;     // Earliest SetupAPI version
enum UINT USE_SP_DRVINFO_DATA_V1 = 1;
+/
enum UINT _SETUPAPI_VER          = _WIN32_WINNT;
enum bool USE_SP_DRVINFO_DATA_V1 = _WIN32_WINNT < 0x500;

enum : uint {
    LINE_LEN                  = 256,
    MAX_INF_STRING_LENGTH     = 4096,
    MAX_TITLE_LEN             = 60,
    MAX_INSTRUCTION_LEN       = 256,
    MAX_LABEL_LEN             = 30,
    MAX_SERVICE_NAME_LEN      = 256,
    MAX_SUBTITLE_LEN          = 256,
    SP_MAX_MACHINENAME_LENGTH = MAX_PATH + 3
}

enum : DWORD {
    COPYFLG_WARN_IF_SKIP         = 0x00000001,
    COPYFLG_NOSKIP               = 0x00000002,
    COPYFLG_NOVERSIONCHECK       = 0x00000004,
    COPYFLG_FORCE_FILE_IN_USE    = 0x00000008,
    COPYFLG_NO_OVERWRITE         = 0x00000010,
    COPYFLG_NO_VERSION_DIALOG    = 0x00000020,
    COPYFLG_OVERWRITE_OLDER_ONLY = 0x00000040,
    COPYFLG_REPLACEONLY          = 0x00000400,
    COPYFLG_NODECOMP             = 0x00000800,
    COPYFLG_REPLACE_BOOT_FILE    = 0x00001000,
    COPYFLG_NOPRUNE              = 0x00002000
}

enum : DWORD {
    DELFLG_IN_USE  = 0x00000001,
    DELFLG_IN_USE1 = 0x00010000
}

enum : DWORD {
    DI_REMOVEDEVICE_GLOBAL              = 0x00000001,
    DI_REMOVEDEVICE_CONFIGSPECIFIC      = 0x00000002,
    DI_UNREMOVEDEVICE_CONFIGSPECIFIC    = 0x00000002,
    DI_SHOWOEM                          = 0x00000001,
    DI_SHOWCOMPAT                       = 0x00000002,
    DI_SHOWCLASS                        = 0x00000004,
    DI_SHOWALL                          = 0x00000007,
    DI_NOVCP                            = 0x00000008,
    DI_DIDCOMPAT                        = 0x00000010,
    DI_DIDCLASS                         = 0x00000020,
    DI_AUTOASSIGNRES                    = 0x00000040,
    DI_NEEDRESTART                      = 0x00000080,
    DI_NEEDREBOOT                       = 0x00000100,
    DI_NOBROWSE                         = 0x00000200,
    DI_MULTMFGS                         = 0x00000400,
    DI_DISABLED                         = 0x00000800,
    DI_GENERALPAGE_ADDED                = 0x00001000,
    DI_RESOURCEPAGE_ADDED               = 0x00002000,
    DI_PROPERTIES_CHANGE                = 0x00004000,
    DI_INF_IS_SORTED                    = 0x00008000,
    DI_ENUMSINGLEINF                    = 0x00010000,
    DI_DONOTCALLCONFIGMG                = 0x00020000,
    DI_INSTALLDISABLED                  = 0x00040000,
    DI_COMPAT_FROM_CLASS                = 0x00080000,
    DI_CLASSINSTALLPARAMS               = 0x00100000,
    DI_NODI_DEFAULTACTION               = 0x00200000,
    DI_QUIETINSTALL                     = 0x00800000,
    DI_NOFILECOPY                       = 0x01000000,
    DI_FORCECOPY                        = 0x02000000,
    DI_DRIVERPAGE_ADDED                 = 0x04000000,
    DI_USECI_SELECTSTRINGS              = 0x08000000,
    DI_OVERRIDE_INFFLAGS                = 0x10000000,
    DI_PROPS_NOCHANGEUSAGE              = 0x20000000,
    DI_NOSELECTICONS                    = 0x40000000,
    DI_NOWRITE_IDS                      = 0x80000000,
    DI_FLAGSEX_USEOLDINFSEARCH          = 0x00000001,
    DI_FLAGSEX_AUTOSELECTRANK0          = 0x00000002,
    DI_FLAGSEX_CI_FAILED                = 0x00000004,
    DI_FLAGSEX_DIDINFOLIST              = 0x00000010,
    DI_FLAGSEX_DIDCOMPATINFO            = 0x00000020,
    DI_FLAGSEX_FILTERCLASSES            = 0x00000040,
    DI_FLAGSEX_SETFAILEDINSTALL         = 0x00000080,
    DI_FLAGSEX_DEVICECHANGE             = 0x00000100,
    DI_FLAGSEX_ALWAYSWRITEIDS           = 0x00000200,
    DI_FLAGSEX_PROPCHANGE_PENDING       = 0x00000400,
    DI_FLAGSEX_ALLOWEXCLUDEDDRVS        = 0x00000800,
    DI_FLAGSEX_NOUIONQUERYREMOVE        = 0x00001000,
    DI_FLAGSEX_USECLASSFORCOMPAT        = 0x00002000,
    DI_FLAGSEX_OLDINF_IN_CLASSLIST      = 0x00004000,
    DI_FLAGSEX_NO_DRVREG_MODIFY         = 0x00008000,
    DI_FLAGSEX_IN_SYSTEM_SETUP          = 0x00010000,
    DI_FLAGSEX_INET_DRIVER              = 0x00020000,
    DI_FLAGSEX_APPENDDRIVERLIST         = 0x00040000,
    DI_FLAGSEX_PREINSTALLBACKUP         = 0x00080000,
    DI_FLAGSEX_BACKUPONREPLACE          = 0x00100000,
    DI_FLAGSEX_DRIVERLIST_FROM_URL      = 0x00200000,
    DI_FLAGSEX_RESERVED1                = 0x00400000,
    DI_FLAGSEX_EXCLUDE_OLD_INET_DRIVERS = 0x00800000,
    DI_FLAGSEX_POWERPAGE_ADDED          = 0x01000000
}

enum : DWORD {
    DIBCI_NOINSTALLCLASS = 0x00000001,
    DIBCI_NODISPLAYCLASS = 0x00000002
}

enum : DWORD {
    DICD_GENERATE_ID       = 0x00000001,
    DICD_INHERIT_CLASSDRVS = 0x00000002
}

enum : DWORD {
    DICS_ENABLE = 1,
    DICS_DISABLE,
    DICS_PROPCHANGE,
    DICS_START,
    DICS_STOP // = 5
}

enum : DWORD {
    DICS_FLAG_GLOBAL         = 1,
    DICS_FLAG_CONFIGSPECIFIC = 2,
    DICS_FLAG_CONFIGGENERAL  = 4
}

alias UINT DI_FUNCTION;

enum : DI_FUNCTION {
    DIF_SELECTDEVICE = 1,
    DIF_INSTALLDEVICE,
    DIF_ASSIGNRESOURCES,
    DIF_PROPERTIES,
    DIF_REMOVE,
    DIF_FIRSTTIMESETUP,
    DIF_FOUNDDEVICE,
    DIF_SELECTCLASSDRIVERS,
    DIF_VALIDATECLASSDRIVERS,
    DIF_INSTALLCLASSDRIVERS,
    DIF_CALCDISKSPACE,
    DIF_DESTROYPRIVATEDATA,
    DIF_VALIDATEDRIVER,
    DIF_MOVEDEVICE,
    DIF_DETECT,
    DIF_INSTALLWIZARD,
    DIF_DESTROYWIZARDDATA,
    DIF_PROPERTYCHANGE,
    DIF_ENABLECLASS,
    DIF_DETECTVERIFY,
    DIF_INSTALLDEVICEFILES,
    DIF_UNREMOVE,
    DIF_SELECTBESTCOMPATDRV,
    DIF_ALLOW_INSTALL,
    DIF_REGISTERDEVICE,
    DIF_NEWDEVICEWIZARD_PRESELECT,
    DIF_NEWDEVICEWIZARD_SELECT,
    DIF_NEWDEVICEWIZARD_PREANALYZE,
    DIF_NEWDEVICEWIZARD_POSTANALYZE,
    DIF_NEWDEVICEWIZARD_FINISHINSTALL,
    DIF_UNUSED1,
    DIF_INSTALLINTERFACES,
    DIF_DETECTCANCEL,
    DIF_REGISTER_COINSTALLERS,
    DIF_ADDPROPERTYPAGE_ADVANCED,
    DIF_ADDPROPERTYPAGE_BASIC,
    DIF_RESERVED1,
    DIF_TROUBLESHOOTER,
    DIF_POWERMESSAGEWAKE // = 39
}

enum : DWORD {
    DIGCF_DEFAULT         = 0x00000001,
    DIGCF_PRESENT         = 0x00000002,
    DIGCF_ALLCLASSES      = 0x00000004,
    DIGCF_PROFILE         = 0x00000008,
    DIGCF_DEVICEINTERFACE = 0x00000010
}

deprecated enum : DWORD {
    DIGCF_INTERFACEDEVICE = DIGCF_DEVICEINTERFACE
}

enum : DWORD {
    DIGCDP_FLAG_BASIC    = 0x00000001,
    DIGCDP_FLAG_ADVANCED = 0x00000002
}

enum : DWORD {
    DIOCR_INSTALLER = 0x00000001,
    DIOCR_INTERFACE = 0x00000002
}

enum : DWORD {
    DIODI_NO_ADD = 0x00000001
}

enum : DWORD {
    DIOD_INHERIT_CLASSDRVS = 0x00000002,
    DIOD_CANCEL_REMOVE     = 0x00000004
}

enum : DWORD {
    DIREG_DEV  = 0x00000001,
    DIREG_DRV  = 0x00000002,
    DIREG_BOTH = 0x00000004
}

enum : int {
    DIRID_ABSOLUTE       = -1,
    DIRID_NULL           = 0,
    DIRID_SRCPATH        = 1,
    DIRID_WINDOWS        = 10,
    DIRID_SYSTEM         = 11,
    DIRID_DRIVERS        = 12,
    DIRID_IOSUBSYS       = DIRID_DRIVERS,
    DIRID_INF            = 17,
    DIRID_HELP           = 18,
    DIRID_FONTS          = 20,
    DIRID_VIEWERS        = 21,
    DIRID_COLOR          = 23,
    DIRID_APPS           = 24,
    DIRID_SHARED         = 25,
    DIRID_BOOT           = 30,
    DIRID_SYSTEM16       = 50,
    DIRID_SPOOL          = 51,
    DIRID_SPOOLDRIVERS   = 52,
    DIRID_USERPROFILE    = 53,
    DIRID_LOADER         = 54,
    DIRID_PRINTPROCESSOR = 55,
    DIRID_DEFAULT        = DIRID_SYSTEM
}

enum : int {
    DIRID_COMMON_STARTMENU        = 16406,
    DIRID_COMMON_PROGRAMS         = 16407,
    DIRID_COMMON_STARTUP          = 16408,
    DIRID_COMMON_DESKTOPDIRECTORY = 16409,
    DIRID_COMMON_FAVORITES        = 16415,
    DIRID_COMMON_APPDATA          = 16419,
    DIRID_PROGRAM_FILES           = 16422,
    DIRID_SYSTEM_X86              = 16425,
    DIRID_PROGRAM_FILES_X86       = 16426,
    DIRID_PROGRAM_FILES_COMMON    = 16427,
    DIRID_PROGRAM_FILES_COMMONX86 = 16428,
    DIRID_COMMON_TEMPLATES        = 16429,
    DIRID_COMMON_DOCUMENTS        = 16430,
    DIRID_USER                    = 0x8000,
    DIRID_ABSOLUTE_16BIT          = 0xffff
}

enum : DWORD {
    DMI_MASK    = 0x00000001,
    DMI_BKCOLOR = 0x00000002,
    DMI_USERECT = 0x00000004
}

enum : DWORD {
    DNF_DUPDESC           = 0x00000001,
    DNF_OLDDRIVER         = 0x00000002,
    DNF_EXCLUDEFROMLIST   = 0x00000004,
    DNF_NODRIVER          = 0x00000008,
    DNF_LEGACYINF         = 0x00000010,
    DNF_CLASS_DRIVER      = 0x00000020,
    DNF_COMPATIBLE_DRIVER = 0x00000040,
    DNF_INET_DRIVER       = 0x00000080,
    DNF_UNUSED1           = 0x00000100,
    DNF_INDEXED_DRIVER    = 0x00000200,
    DNF_OLD_INET_DRIVER   = 0x00000400,
    DNF_BAD_DRIVER        = 0x00000800,
    DNF_DUPPROVIDER       = 0x00001000
}

enum : UINT {
    DPROMPT_SUCCESS,
    DPROMPT_CANCEL,
    DPROMPT_SKIPFILE,
    DPROMPT_BUFFERTOOSMALL,
    DPROMPT_OUTOFMEMORY // = 4
}

enum : DWORD {
    DRIVER_HARDWAREID_RANK             = 0x00000FFF,
    DRIVER_COMPATID_RANK               = 0x00003FFF,
    DRIVER_UNTRUSTED_RANK              = 0x00008000,
    DRIVER_UNTRUSTED_HARDWAREID_RANK   = 0x00008FFF,
    DRIVER_UNTRUSTED_COMPATID_RANK     = 0x0000BFFF,
    DRIVER_W9X_SUSPECT_RANK            = 0x0000C000,
    DRIVER_W9X_SUSPECT_HARDWAREID_RANK = 0x0000CFFF,
    DRIVER_W9X_SUSPECT_COMPATID_RANK   = 0x0000FFFF
}

enum : DWORD {
    DYNAWIZ_FLAG_PAGESADDED             = 0x00000001,
    DYNAWIZ_FLAG_INSTALLDET_NEXT        = 0x00000002,
    DYNAWIZ_FLAG_INSTALLDET_PREV        = 0x00000004,
    DYNAWIZ_FLAG_ANALYZE_HANDLECONFLICT = 0x00000008
}

enum : WORD {
    ENABLECLASS_QUERY,
    ENABLECLASS_SUCCESS,
    ENABLECLASS_FAILURE // = 2
}

enum : DWORD {
    ERROR_EXPECTED_SECTION_NAME       = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0,
    ERROR_BAD_SECTION_NAME_LINE       = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 1,
    ERROR_SECTION_NAME_TOO_LONG       = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 2,
    ERROR_GENERAL_SYNTAX              = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 3,
    ERROR_WRONG_INF_STYLE             = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x100,
    ERROR_NOT_INSTALLED               = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x1000,
    ERROR_SECTION_NOT_FOUND           = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x101,
    ERROR_LINE_NOT_FOUND              = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x102,
    ERROR_NO_BACKUP                   = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x103,
    ERROR_NO_ASSOCIATED_CLASS         = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x200,
    ERROR_CLASS_MISMATCH              = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x201,
    ERROR_DUPLICATE_FOUND             = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x202,
    ERROR_NO_DRIVER_SELECTED          = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x203,
    ERROR_KEY_DOES_NOT_EXIST          = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x204,
    ERROR_INVALID_DEVINST_NAME        = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x205,
    ERROR_INVALID_CLASS               = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x206,
    ERROR_DEVINST_ALREADY_EXISTS      = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x207,
    ERROR_DEVINFO_NOT_REGISTERED      = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x208,
    ERROR_INVALID_REG_PROPERTY        = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x209,
    ERROR_NO_INF                      = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x20A,
    ERROR_NO_SUCH_DEVINST             = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x20B,
    ERROR_CANT_LOAD_CLASS_ICON        = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x20C,
    ERROR_INVALID_CLASS_INSTALLER     = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x20D,
    ERROR_DI_DO_DEFAULT               = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x20E,
    ERROR_DI_NOFILECOPY               = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x20F,
    ERROR_INVALID_HWPROFILE           = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x210,
    ERROR_NO_DEVICE_SELECTED          = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x211,
    ERROR_DEVINFO_LIST_LOCKED         = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x212,
    ERROR_DEVINFO_DATA_LOCKED         = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x213,
    ERROR_DI_BAD_PATH                 = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x214,
    ERROR_NO_CLASSINSTALL_PARAMS      = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x215,
    ERROR_FILEQUEUE_LOCKED            = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x216,
    ERROR_BAD_SERVICE_INSTALLSECT     = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x217,
    ERROR_NO_CLASS_DRIVER_LIST        = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x218,
    ERROR_NO_ASSOCIATED_SERVICE       = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x219,
    ERROR_NO_DEFAULT_DEVICE_INTERFACE = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x21A,
    ERROR_DEVICE_INTERFACE_ACTIVE     = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x21B,
    ERROR_DEVICE_INTERFACE_REMOVED    = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x21C,
    ERROR_BAD_INTERFACE_INSTALLSECT   = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x21D,
    ERROR_NO_SUCH_INTERFACE_CLASS     = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x21E,
    ERROR_INVALID_REFERENCE_STRING    = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x21F,
    ERROR_INVALID_MACHINENAME         = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x220,
    ERROR_REMOTE_COMM_FAILURE         = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x221,
    ERROR_MACHINE_UNAVAILABLE         = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x222,
    ERROR_NO_CONFIGMGR_SERVICES       = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x223,
    ERROR_INVALID_PROPPAGE_PROVIDER   = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x224,
    ERROR_NO_SUCH_DEVICE_INTERFACE    = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x225,
    ERROR_DI_POSTPROCESSING_REQUIRED  = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x226,
    ERROR_INVALID_COINSTALLER         = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x227,
    ERROR_NO_COMPAT_DRIVERS           = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x228,
    ERROR_NO_DEVICE_ICON              = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x229,
    ERROR_INVALID_INF_LOGCONFIG       = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x22A,
    ERROR_DI_DONT_INSTALL             = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x22B,
    ERROR_INVALID_FILTER_DRIVER       = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x22C,
    ERROR_NON_WINDOWS_NT_DRIVER       = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x22D,
    ERROR_NON_WINDOWS_DRIVER          = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x22E,
    ERROR_NO_CATALOG_FOR_OEM_INF      = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x22F,
    ERROR_DEVINSTALL_QUEUE_NONNATIVE  = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x230,
    ERROR_NOT_DISABLEABLE             = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x231,
    ERROR_CANT_REMOVE_DEVINST         = APPLICATION_ERROR_MASK | ERROR_SEVERITY_ERROR | 0x232
}

deprecated enum : DWORD {
    ERROR_NO_DEFAULT_INTERFACE_DEVICE = ERROR_NO_DEFAULT_DEVICE_INTERFACE,
    ERROR_INTERFACE_DEVICE_ACTIVE     = ERROR_DEVICE_INTERFACE_ACTIVE,
    ERROR_INTERFACE_DEVICE_REMOVED    = ERROR_DEVICE_INTERFACE_REMOVED,
    ERROR_NO_SUCH_INTERFACE_DEVICE    = ERROR_NO_SUCH_DEVICE_INTERFACE,
}

enum : UINT {
    FILEOP_COPY,
    FILEOP_RENAME,
    FILEOP_DELETE,
    FILEOP_BACKUP,
    FILEOP_NEWPATH, // = 4
    FILEOP_ABORT = 0,
    FILEOP_DOIT,
    FILEOP_SKIP, // = 2
    FILEOP_RETRY = FILEOP_DOIT
}

enum : UINT {
    FILE_COMPRESSION_NONE,
    FILE_COMPRESSION_WINLZA,
    FILE_COMPRESSION_MSZIP,
    FILE_COMPRESSION_NTCAB // = 3
}

enum : DWORD {
    FLG_ADDREG_TYPE_SZ        = 0x00000000,
    FLG_ADDREG_BINVALUETYPE   = 0x00000001,
    FLG_ADDREG_NOCLOBBER      = 0x00000002,
    FLG_ADDREG_DELVAL         = 0x00000004,
    FLG_ADDREG_APPEND         = 0x00000008,
    FLG_ADDREG_KEYONLY        = 0x00000010,
    FLG_ADDREG_OVERWRITEONLY  = 0x00000020,
    FLG_ADDREG_TYPE_MULTI_SZ  = 0x00010000,
    FLG_ADDREG_TYPE_EXPAND_SZ = 0x00020000,
    FLG_ADDREG_TYPE_BINARY    = 0x00000000 | FLG_ADDREG_BINVALUETYPE,
    FLG_ADDREG_TYPE_DWORD     = 0x00010000 | FLG_ADDREG_BINVALUETYPE,
    FLG_ADDREG_TYPE_NONE      = 0x00020000 | FLG_ADDREG_BINVALUETYPE,
    FLG_ADDREG_TYPE_MASK      = 0xFFFF0000 | FLG_ADDREG_BINVALUETYPE
}

static if (_SETUPAPI_VER >= 0x0501) {
    enum : DWORD {
        FLG_ADDREG_64BITKEY       = 0x00001000,
        FLG_ADDREG_KEYONLY_COMMON = 0x00002000,
        FLG_ADDREG_32BITKEY       = 0x00004000,
        FLG_ADDREG_DELREG_BIT     = 0x00008000
    }
}

enum : DWORD {
    FLG_DELREG_VALUE = 0x00000000
}

static if (_SETUPAPI_VER >= 0x0501) {
    enum : DWORD {
        FLG_DELREG_TYPE_MASK          = FLG_ADDREG_TYPE_MASK,
        FLG_DELREG_TYPE_SZ            = FLG_ADDREG_TYPE_SZ,
        FLG_DELREG_TYPE_MULTI_SZ      = FLG_ADDREG_TYPE_MULTI_SZ,
        FLG_DELREG_TYPE_EXPAND_SZ     = FLG_ADDREG_TYPE_EXPAND_SZ,
        FLG_DELREG_TYPE_BINARY        = FLG_ADDREG_TYPE_BINARY,
        FLG_DELREG_TYPE_DWORD         = FLG_ADDREG_TYPE_DWORD,
        FLG_DELREG_TYPE_NONE          = FLG_ADDREG_TYPE_NONE,
        FLG_DELREG_64BITKEY           = FLG_ADDREG_64BITKEY,
        FLG_DELREG_KEYONLY_COMMON     = FLG_ADDREG_KEYONLY_COMMON,
        FLG_DELREG_32BITKEY           = FLG_ADDREG_32BITKEY,
        FLG_DELREG_OPERATION_MASK     = 0x000000FE,
        FLG_DELREG_MULTI_SZ_DELSTRING = 0x00000002 | FLG_DELREG_TYPE_MULTI_SZ | FLG_ADDREG_DELREG_BIT
    }
}

enum : DWORD {
    FLG_BITREG_CLEARBITS = 0x00000000,
    FLG_BITREG_SETBITS   = 0x00000001
}

static if (_SETUPAPI_VER >= 0x0501) {
    enum : DWORD {
        FLG_BITREG_64BITKEY = 0x00001000,
        FLG_BITREG_32BITKEY = 0x00004000
    }
}

enum : DWORD {
    FLG_PROFITEM_CURRENTUSER = 0x00000001,
    FLG_PROFITEM_DELETE      = 0x00000002,
    FLG_PROFITEM_GROUP       = 0x00000004,
    FLG_PROFITEM_CSIDL       = 0x00000008
}

enum : DWORD {
    FLG_REGSVR_DLLREGISTER = 0x00000001,
    FLG_REGSVR_DLLINSTALL  = 0x00000002
}

enum {
    IDD_DYNAWIZ_FIRSTPAGE = 10000,
    IDD_DYNAWIZ_SELECT_PREVPAGE,
    IDD_DYNAWIZ_SELECT_NEXTPAGE,
    IDD_DYNAWIZ_ANALYZE_PREVPAGE,
    IDD_DYNAWIZ_ANALYZE_NEXTPAGE, // = 1004
    IDD_DYNAWIZ_INSTALLDETECTED_PREVPAGE = 10006,
    IDD_DYNAWIZ_INSTALLDETECTED_NEXTPAGE,
    IDD_DYNAWIZ_INSTALLDETECTED_NODEVS,
    IDD_DYNAWIZ_SELECTDEV_PAGE,
    IDD_DYNAWIZ_ANALYZEDEV_PAGE,
    IDD_DYNAWIZ_INSTALLDETECTEDDEVS_PAGE,
    IDD_DYNAWIZ_SELECTCLASS_PAGE, // = 10012
    MIN_IDD_DYNAWIZ_RESOURCE_ID = 10000,
    MAX_IDD_DYNAWIZ_RESOURCE_ID = 11000
}

enum : DWORD {
    IDF_NOBROWSE     = 0x00000001,
    IDF_NOSKIP       = 0x00000002,
    IDF_NODETAILS    = 0x00000004,
    IDF_NOCOMPRESSED = 0x00000008,
    IDF_CHECKFIRST   = 0x00000100,
    IDF_NOBEEP       = 0x00000200,
    IDF_NOFOREGROUND = 0x00000400,
    IDF_WARNIFSKIP   = 0x00000800
}

static if (_SETUPAPI_VER >= 0x0501) {
    enum : DWORD {
        IDF_NOREMOVABLEMEDIAPROMPT = 0x00001000,
        IDF_USEDISKNAMEASPROMPT    = 0x00002000,
        IDF_OEMDISK                = 0x80000000
    }
}

enum {
    IDI_RESOURCEFIRST          = 159,
    IDI_RESOURCE               = 159,
    IDI_RESOURCELAST           = 161,
    IDI_RESOURCEOVERLAYFIRST   = 161,
    IDI_RESOURCEOVERLAYLAST    = 161,
    IDI_CONFLICT               = 161,
    IDI_PROBLEM_OVL            = 500,
    IDI_DISABLED_OVL           = 501,
    IDI_FORCED_OVL             = 502,
    IDI_CLASSICON_OVERLAYFIRST = 500,
    IDI_CLASSICON_OVERLAYLAST  = 502
}

enum : DWORD {
    INF_STYLE_NONE          = 0x00000000,
    INF_STYLE_OLDNT         = 0x00000001,
    INF_STYLE_WIN4          = 0x00000002,
    INF_STYLE_CACHE_ENABLE  = 0x00000010,
    INF_STYLE_CACHE_DISABLE = 0x00000020
}

enum : DWORD {
    INFINFO_INF_SPEC_IS_HINF = 1,
    INFINFO_INF_NAME_IS_ABSOLUTE,
    INFINFO_DEFAULT_SEARCH,
    INFINFO_REVERSE_DEFAULT_SEARCH,
    INFINFO_INF_PATH_LIST_SEARCH // = 5
}

alias DWORD LogSeverity;
enum : LogSeverity {
    LogSevInformation,
    LogSevWarning,
    LogSevError,
    LogSevFatalError,
    LogSevMaximum // = 4
}

enum MAX_INSTALLWIZARD_DYNAPAGES = 20;

enum : DWORD {
    NDW_INSTALLFLAG_DIDFACTDEFS        = 0x00000001,
    NDW_INSTALLFLAG_HARDWAREALLREADYIN = 0x00000002,
    NDW_INSTALLFLAG_NEEDSHUTDOWN       = 0x00000200,
    NDW_INSTALLFLAG_EXPRESSINTRO       = 0x00000400,
    NDW_INSTALLFLAG_SKIPISDEVINSTALLED = 0x00000800,
    NDW_INSTALLFLAG_NODETECTEDDEVS     = 0x00001000,
    NDW_INSTALLFLAG_INSTALLSPECIFIC    = 0x00002000,
    NDW_INSTALLFLAG_SKIPCLASSLIST      = 0x00004000,
    NDW_INSTALLFLAG_CI_PICKED_OEM      = 0x00008000,
    NDW_INSTALLFLAG_PCMCIAMODE         = 0x00010000,
    NDW_INSTALLFLAG_PCMCIADEVICE       = 0x00020000,
    NDW_INSTALLFLAG_USERCANCEL         = 0x00040000,
    NDW_INSTALLFLAG_KNOWNCLASS         = 0x00080000,
    NDW_INSTALLFLAG_NEEDRESTART        = 0x00000080,
    NDW_INSTALLFLAG_NEEDREBOOT         = 0x00000100
}

enum : DWORD {
    SETDIRID_NOT_FULL_PATH = 0x00000001
}

enum : DWORD {
    SP_COPY_DELETESOURCE        = 0x0000001,
    SP_COPY_REPLACEONLY         = 0x0000002,
    SP_COPY_NEWER               = 0x0000004,
    SP_COPY_NEWER_OR_SAME       = 0x0000004,
    SP_COPY_NOOVERWRITE         = 0x0000008,
    SP_COPY_NODECOMP            = 0x0000010,
    SP_COPY_LANGUAGEAWARE       = 0x0000020,
    SP_COPY_SOURCE_ABSOLUTE     = 0x0000040,
    SP_COPY_SOURCEPATH_ABSOLUTE = 0x0000080,
    SP_COPY_IN_USE_NEEDS_REBOOT = 0x0000100,
    SP_COPY_FORCE_IN_USE        = 0x0000200,
    SP_COPY_NOSKIP              = 0x0000400,
    SP_FLAG_CABINETCONTINUATION = 0x0000800,
    SP_COPY_FORCE_NOOVERWRITE   = 0x0001000,
    SP_COPY_FORCE_NEWER         = 0x0002000,
    SP_COPY_WARNIFSKIP          = 0x0004000,
    SP_COPY_NOBROWSE            = 0x0008000,
    SP_COPY_NEWER_ONLY          = 0x0010000,
    SP_COPY_SOURCE_SIS_MASTER   = 0x0020000,
    SP_COPY_OEMINF_CATALOG_ONLY = 0x0040000,
    SP_COPY_REPLACE_BOOT_FILE   = 0x0080000,
    SP_COPY_NOPRUNE             = 0x0100000
}

static if (_SETUPAPI_VER >= 0x0501) {
    enum : DWORD {
        SP_COPY_OEM_F6_INF = 0x0200000
    }
}

enum : DWORD {
    SPCRP_SECURITY = 23,
    SPCRP_SECURITY_SDS,
    SPCRP_DEVTYPE,
    SPCRP_EXCLUSIVE,
    SPCRP_CHARACTERISTICS,
    SPCRP_MAXIMUM_PROPERTY // = 28
}

enum : DWORD {
    SPDIT_NODRIVER,
    SPDIT_CLASSDRIVER,
    SPDIT_COMPATDRIVER // = 2
}

enum : DWORD {
    SPDRP_DEVICEDESC,
    SPDRP_HARDWAREID,
    SPDRP_COMPATIBLEIDS,
    SPDRP_UNUSED0,
    SPDRP_SERVICE,
    SPDRP_UNUSED1,
    SPDRP_UNUSED2,
    SPDRP_CLASS,
    SPDRP_CLASSGUID,
    SPDRP_DRIVER,
    SPDRP_CONFIGFLAGS,
    SPDRP_MFG,
    SPDRP_FRIENDLYNAME,
    SPDRP_LOCATION_INFORMATION,
    SPDRP_PHYSICAL_DEVICE_OBJECT_NAME,
    SPDRP_CAPABILITIES,
    SPDRP_UI_NUMBER,
    SPDRP_UPPERFILTERS,
    SPDRP_LOWERFILTERS,
    SPDRP_BUSTYPEGUID,
    SPDRP_LEGACYBUSTYPE,
    SPDRP_BUSNUMBER,
    SPDRP_ENUMERATOR_NAME,
    SPDRP_SECURITY,
    SPDRP_SECURITY_SDS,
    SPDRP_DEVTYPE,
    SPDRP_EXCLUSIVE,
    SPDRP_CHARACTERISTICS,
    SPDRP_ADDRESS, // = 28
    SPDRP_UI_NUMBER_DESC_FORMAT = 30,
    SPDRP_MAXIMUM_PROPERTY      = 31
}

enum : UINT {
    SPDSL_IGNORE_DISK = 1,
    SPDSL_DISALLOW_NEGATIVE_ADJUST
}

enum : UINT {
    SPFILENOTIFY_STARTQUEUE = 1,
    SPFILENOTIFY_ENDQUEUE,
    SPFILENOTIFY_STARTSUBQUEUE,
    SPFILENOTIFY_ENDSUBQUEUE,
    SPFILENOTIFY_STARTDELETE,
    SPFILENOTIFY_ENDDELETE,
    SPFILENOTIFY_DELETEERROR,
    SPFILENOTIFY_STARTRENAME,
    SPFILENOTIFY_ENDRENAME,
    SPFILENOTIFY_RENAMEERROR,
    SPFILENOTIFY_STARTCOPY,
    SPFILENOTIFY_ENDCOPY,
    SPFILENOTIFY_COPYERROR,
    SPFILENOTIFY_NEEDMEDIA,
    SPFILENOTIFY_QUEUESCAN,
    SPFILENOTIFY_CABINETINFO,
    SPFILENOTIFY_FILEINCABINET,
    SPFILENOTIFY_NEEDNEWCABINET,
    SPFILENOTIFY_FILEEXTRACTED,
    SPFILENOTIFY_FILEOPDELAYED,
    SPFILENOTIFY_STARTBACKUP,
    SPFILENOTIFY_BACKUPERROR,
    SPFILENOTIFY_ENDBACKUP,
    SPFILENOTIFY_QUEUESCAN_EX,
    SPFILENOTIFY_STARTREGISTRATION, // = 25
    SPFILENOTIFY_ENDREGISTRATION = 32,
    SPFILENOTIFY_LANGMISMATCH    = 0x00010000,
    SPFILENOTIFY_TARGETEXISTS    = 0x00020000,
    SPFILENOTIFY_TARGETNEWER     = 0x00040000
}

static if (_SETUPAPI_VER >= 0x0501) {
    enum : UINT {
        SPFILENOTIFY_QUEUESCAN_SIGNERINFO = 0x00000040
    }
}

enum : DWORD {
    SPFILELOG_SYSTEMLOG = 0x00000001,
    SPFILELOG_OEMFILE   = 0x00000001,
    SPFILELOG_FORCENEW  = 0x00000002,
    SPFILELOG_QUERYONLY = 0x00000004
}

enum : INT {
    SPFILEQ_FILE_IN_USE        = 0x00000001,
    SPFILEQ_REBOOT_RECOMMENDED = 0x00000002,
    SPFILEQ_REBOOT_IN_PROGRESS = 0x00000004
}

enum : DWORD {
    SPINT_ACTIVE  = 0x00000001,
    SPINT_DEFAULT = 0x00000002,
    SPINT_REMOVED = 0x00000004
}

deprecated enum : DWORD {
    SPID_ACTIVE  = SPINT_ACTIVE,
    SPID_DEFAULT = SPINT_DEFAULT,
    SPID_REMOVED = SPINT_REMOVED
}

enum : UINT {
    SPINST_LOGCONFIG                = 0x00000001,
    SPINST_INIFILES                 = 0x00000002,
    SPINST_REGISTRY                 = 0x00000004,
    SPINST_INI2REG                  = 0x00000008,
    SPINST_FILES                    = 0x00000010,
    SPINST_BITREG                   = 0x00000020,
    SPINST_REGSVR                   = 0x00000040,
    SPINST_UNREGSVR                 = 0x00000080,
    SPINST_PROFILEITEMS             = 0x00000100,
    SPINST_SINGLESECTION            = 0x00010000,
    SPINST_LOGCONFIG_IS_FORCED      = 0x00020000,
    SPINST_LOGCONFIGS_ARE_OVERRIDES = 0x00040000
}

static if (_SETUPAPI_VER >= 0x0501) {
    enum : UINT {
        SPINST_COPYINF               = 0x00000200,
        SPINST_ALL                   = 0x000003ff,
        SPINST_REGISTERCALLBACKAWARE = 0x00080000
    }
} else {
    enum : UINT {
        SPINST_ALL = 0x000001ff
    }
}

enum : DWORD {
    SPOST_NONE,
    SPOST_PATH,
    SPOST_URL,
    SPOST_MAX // = 3
}

enum : DWORD {
    SPPSR_SELECT_DEVICE_RESOURCES = 1,
    SPPSR_ENUM_BASIC_DEVICE_PROPERTIES,
    SPPSR_ENUM_ADV_DEVICE_PROPERTIES
}

enum : DWORD {
    SPQ_SCAN_FILE_PRESENCE    = 0x00000001,
    SPQ_SCAN_FILE_VALIDITY    = 0x00000002,
    SPQ_SCAN_USE_CALLBACK     = 0x00000004,
    SPQ_SCAN_USE_CALLBACKEX   = 0x00000008,
    SPQ_SCAN_INFORM_USER      = 0x00000010,
    SPQ_SCAN_PRUNE_COPY_QUEUE = 0x00000020
}

static if (_SETUPAPI_VER >= 0x0501) {
    enum : DWORD {
        SPQ_SCAN_USE_CALLBACK_SIGNERINFO = 0x00000040,
        SPQ_SCAN_PRUNE_DELREN            = 0x00000080
    }
}

enum : UINT_PTR {
    SPQ_DELAYED_COPY = 0x00000001
}

enum : DWORD {
    SPRDI_FIND_DUPS = 0x00000001,
}

enum : DWORD {
    SPSVCINST_TAGTOFRONT               = 0x00000001,
    SPSVCINST_ASSOCSERVICE             = 0x00000002,
    SPSVCINST_DELETEEVENTLOGENTRY      = 0x00000004,
    SPSVCINST_NOCLOBBER_DISPLAYNAME    = 0x00000008,
    SPSVCINST_NOCLOBBER_STARTTYPE      = 0x00000010,
    SPSVCINST_NOCLOBBER_ERRORCONTROL   = 0x00000020,
    SPSVCINST_NOCLOBBER_LOADORDERGROUP = 0x00000040,
    SPSVCINST_NOCLOBBER_DEPENDENCIES   = 0x00000080,
    SPSVCINST_NOCLOBBER_DESCRIPTION    = 0x00000100,
    SPSVCINST_STOPSERVICE              = 0x00000200
}

static if (_SETUPAPI_VER >= 0x0501) {
    enum : DWORD {
        SPSVCINST_CLOBBER_SECURITY = 0x00000400
    }
}

enum : DWORD {
    SPWPT_SELECTDEVICE = 0x00000001
}

enum : DWORD {
    SPWP_USE_DEVINFO_DATA = 0x00000001
}

enum : UINT {
    SRCINFO_PATH = 1,
    SRCINFO_TAGFILE,
    SRCINFO_DESCRIPTION,
    SRCINFO_FLAGS // = 4
}

enum : DWORD {
    SRCLIST_TEMPORARY       = 0x00000001,
    SRCLIST_NOBROWSE        = 0x00000002,
    SRCLIST_SYSTEM          = 0x00000010,
    SRCLIST_USER            = 0x00000020,
    SRCLIST_SYSIFADMIN      = 0x00000040,
    SRCLIST_SUBDIRS         = 0x00000100,
    SRCLIST_APPEND          = 0x00000200,
    SRCLIST_NOSTRIPPLATFORM = 0x00000400
}

alias PVOID HINF;
alias PVOID HDSKSPC;
mixin DECLARE_HANDLE!("HDEVINFO");
alias PVOID HSPFILEQ;
alias PVOID HSPFILELOG;

enum SetupFileLogInfo {
    SetupFileLogSourceFilename,
    SetupFileLogChecksum,
    SetupFileLogDiskTagfile,
    SetupFileLogDiskDescription,
    SetupFileLogOtherInfo,
    SetupFileLogMax
}

version (Win64)
    private enum _alignVal = 0;
else
    private enum _alignVal = 1;

struct INFCONTEXT {
    PVOID Inf;
    PVOID CurrentInf;
    UINT  Section;
    UINT  Line;
}
alias INFCONTEXT* PINFCONTEXT;

mixin AlignedStr!(_alignVal, "SP_INF_INFORMATION", q{
    DWORD InfStyle;
    DWORD InfCount;
    BYTE[1] _VersionData;
    BYTE* VersionData() return { return _VersionData.ptr; }
});
alias SP_INF_INFORMATION* PSP_INF_INFORMATION;

struct SP_ALTPLATFORM_INFO {
    DWORD cbSize = SP_ALTPLATFORM_INFO.sizeof;
    DWORD Platform;
    DWORD MajorVersion;
    DWORD MinorVersion;
    WORD  ProcessorArchitecture;
    WORD  Reserved;
}
alias SP_ALTPLATFORM_INFO* PSP_ALTPLATFORM_INFO;

struct SP_ORIGINAL_FILE_INFO_A {
    DWORD cbSize = SP_ORIGINAL_FILE_INFO_A.sizeof;
    CHAR[MAX_PATH] OriginalInfName = 0;
    CHAR[MAX_PATH] OriginalCatalogName = 0;
}
alias SP_ORIGINAL_FILE_INFO_A* PSP_ORIGINAL_FILE_INFO_A;

struct SP_ORIGINAL_FILE_INFO_W {
    DWORD cbSize = SP_ORIGINAL_FILE_INFO_W.sizeof;
    WCHAR[MAX_PATH] OriginalInfName = 0;
    WCHAR[MAX_PATH] OriginalCatalogName = 0;
}
alias SP_ORIGINAL_FILE_INFO_W* PSP_ORIGINAL_FILE_INFO_W;

struct FILEPATHS_A {
    PCSTR Target;
    PCSTR Source;
    UINT  Win32Error;
    DWORD Flags;
}
alias FILEPATHS_A* PFILEPATHS_A;

struct FILEPATHS_W {
    PCWSTR Target;
    PCWSTR Source;
    UINT   Win32Error;
    DWORD  Flags;
}
alias FILEPATHS_W* PFILEPATHS_W;

struct SOURCE_MEDIA_A {
    PCSTR Reserved;
    PCSTR Tagfile;
    PCSTR Description;
    PCSTR SourcePath;
    PCSTR SourceFile;
    DWORD Flags;
}
alias SOURCE_MEDIA_A* PSOURCE_MEDIA_A;

struct SOURCE_MEDIA_W {
    PCWSTR Reserved;
    PCWSTR Tagfile;
    PCWSTR Description;
    PCWSTR SourcePath;
    PCWSTR SourceFile;
    DWORD  Flags;
}
alias SOURCE_MEDIA_W* PSOURCE_MEDIA_W;

struct CABINET_INFO_A {
    PCSTR  CabinetPath;
    PCSTR  CabinetFile;
    PCSTR  DiskName;
    USHORT SetId;
    USHORT CabinetNumber;
}
alias CABINET_INFO_A* PCABINET_INFO_A;

struct CABINET_INFO_W {
    PCWSTR CabinetPath;
    PCWSTR CabinetFile;
    PCWSTR DiskName;
    USHORT SetId;
    USHORT CabinetNumber;
}
alias CABINET_INFO_W* PCABINET_INFO_W;

mixin AlignedStr!(_alignVal, "FILE_IN_CABINET_INFO_A", q{
    PCSTR NameInCabinet;
    DWORD FileSize;
    DWORD Win32Error;
    WORD  DosDate;
    WORD  DosTime;
    WORD  DosAttribs;
    CHAR[MAX_PATH] FullTargetName = 0;
});
alias FILE_IN_CABINET_INFO_A* PFILE_IN_CABINET_INFO_A;

mixin AlignedStr!(_alignVal, "FILE_IN_CABINET_INFO_W", q{
    PCWSTR NameInCabinet;
    DWORD  FileSize;
    DWORD  Win32Error;
    WORD   DosDate;
    WORD   DosTime;
    WORD   DosAttribs;
    WCHAR[MAX_PATH] FullTargetName = 0;
});
alias FILE_IN_CABINET_INFO_W* PFILE_IN_CABINET_INFO_W;

struct SP_FILE_COPY_PARAMS_A {
    DWORD    cbSize = SP_FILE_COPY_PARAMS_A.sizeof;
    HSPFILEQ QueueHandle;
    PCSTR    SourceRootPath;
    PCSTR    SourcePath;
    PCSTR    SourceFilename;
    PCSTR    SourceDescription;
    PCSTR    SourceTagfile;
    PCSTR    TargetDirectory;
    PCSTR    TargetFilename;
    DWORD    CopyStyle;
    HINF     LayoutInf;
    PCSTR    SecurityDescriptor;
}
alias SP_FILE_COPY_PARAMS_A* PSP_FILE_COPY_PARAMS_A;

struct SP_FILE_COPY_PARAMS_W {
    DWORD    cbSize = SP_FILE_COPY_PARAMS_W.sizeof;
    HSPFILEQ QueueHandle;
    PCWSTR   SourceRootPath;
    PCWSTR   SourcePath;
    PCWSTR   SourceFilename;
    PCWSTR   SourceDescription;
    PCWSTR   SourceTagfile;
    PCWSTR   TargetDirectory;
    PCWSTR   TargetFilename;
    DWORD    CopyStyle;
    HINF     LayoutInf;
    PCWSTR   SecurityDescriptor;
}
alias SP_FILE_COPY_PARAMS_W* PSP_FILE_COPY_PARAMS_W;

struct SP_DEVINFO_DATA {
    DWORD     cbSize = SP_DEVINFO_DATA.sizeof;
    GUID      ClassGuid;
    DWORD     DevInst;
    ULONG_PTR Reserved;
}
alias SP_DEVINFO_DATA* PSP_DEVINFO_DATA;

mixin AlignedStr!(_alignVal, "SP_DEVICE_INTERFACE_DATA", q{
    DWORD     cbSize = SP_DEVICE_INTERFACE_DATA.sizeof;
    GUID      InterfaceClassGuid;
    DWORD     Flags;
    ULONG_PTR Reserved;
});
alias SP_DEVICE_INTERFACE_DATA* PSP_DEVICE_INTERFACE_DATA;
deprecated alias SP_DEVICE_INTERFACE_DATA SP_INTERFACE_DEVICE_DATA;
deprecated alias SP_DEVICE_INTERFACE_DATA* PSP_INTERFACE_DEVICE_DATA;

mixin AlignedStr!(_alignVal, "SP_DEVICE_INTERFACE_DETAIL_DATA_A", q{
    DWORD cbSize = SP_DEVICE_INTERFACE_DETAIL_DATA_A.sizeof;
    CHAR[1] _DevicePath = 0;
    CHAR* DevicePath() return { return _DevicePath.ptr; }
});
alias SP_DEVICE_INTERFACE_DETAIL_DATA_A* PSP_DEVICE_INTERFACE_DETAIL_DATA_A;

mixin AlignedStr!(_alignVal, "SP_DEVICE_INTERFACE_DETAIL_DATA_W", q{
    DWORD  cbSize = SP_DEVICE_INTERFACE_DETAIL_DATA_W.sizeof;
    WCHAR[1] _DevicePath = 0;
    WCHAR* DevicePath() return { return _DevicePath.ptr; }
});
alias SP_DEVICE_INTERFACE_DETAIL_DATA_W* PSP_DEVICE_INTERFACE_DETAIL_DATA_W;

deprecated alias SP_DEVICE_INTERFACE_DETAIL_DATA_A SP_INTERFACE_DEVICE_DETAIL_DATA_A;
deprecated alias SP_DEVICE_INTERFACE_DETAIL_DATA_A* PSP_INTERFACE_DEVICE_DETAIL_DATA_A;
deprecated alias SP_DEVICE_INTERFACE_DETAIL_DATA_W SP_INTERFACE_DEVICE_DETAIL_DATA_W;
deprecated alias SP_DEVICE_INTERFACE_DETAIL_DATA_W* PSP_INTERFACE_DEVICE_DETAIL_DATA_W;

mixin AlignedStr!(_alignVal, "SP_DEVINFO_LIST_DETAIL_DATA_A", q{
    DWORD  cbSize = SP_DEVINFO_LIST_DETAIL_DATA_A.sizeof;
    GUID   ClassGuid;
    HANDLE RemoteMachineHandle;
    CHAR[SP_MAX_MACHINENAME_LENGTH] RemoteMachineName = 0;
});
alias SP_DEVINFO_LIST_DETAIL_DATA_A* PSP_DEVINFO_LIST_DETAIL_DATA_A;

mixin AlignedStr!(_alignVal, "SP_DEVINFO_LIST_DETAIL_DATA_W", q{
    DWORD  cbSize = SP_DEVINFO_LIST_DETAIL_DATA_W.sizeof;
    GUID   ClassGuid;
    HANDLE RemoteMachineHandle;
    WCHAR[SP_MAX_MACHINENAME_LENGTH] RemoteMachineName = 0;
});
alias SP_DEVINFO_LIST_DETAIL_DATA_W* PSP_DEVINFO_LIST_DETAIL_DATA_W;

extern(Windows) alias UINT function(PVOID, UINT, UINT_PTR, UINT_PTR) PSP_FILE_CALLBACK_A;
extern(Windows) alias UINT function(PVOID, UINT, UINT_PTR, UINT_PTR) PSP_FILE_CALLBACK_W;

struct SP_DEVINSTALL_PARAMS_A {
    DWORD               cbSize = SP_DEVINSTALL_PARAMS_A.sizeof;
    DWORD               Flags;
    DWORD               FlagsEx;
    HWND                hwndParent;
    PSP_FILE_CALLBACK_A InstallMsgHandler;
    PVOID               InstallMsgHandlerContext;
    HSPFILEQ            FileQueue;
    ULONG_PTR           ClassInstallReserved;
    DWORD               Reserved;
    CHAR[MAX_PATH]      DriverPath = 0;
}
alias SP_DEVINSTALL_PARAMS_A* PSP_DEVINSTALL_PARAMS_A;

struct SP_DEVINSTALL_PARAMS_W {
    DWORD               cbSize = SP_DEVINSTALL_PARAMS_W.sizeof;
    DWORD               Flags;
    DWORD               FlagsEx;
    HWND                hwndParent;
    PSP_FILE_CALLBACK_W InstallMsgHandler;
    PVOID               InstallMsgHandlerContext;
    HSPFILEQ            FileQueue;
    ULONG_PTR           ClassInstallReserved;
    DWORD               Reserved;
    WCHAR[MAX_PATH]     DriverPath = 0;
}
alias SP_DEVINSTALL_PARAMS_W* PSP_DEVINSTALL_PARAMS_W;

struct SP_CLASSINSTALL_HEADER {
    DWORD       cbSize = SP_CLASSINSTALL_HEADER.sizeof;
    DI_FUNCTION InstallFunction;
}
alias SP_CLASSINSTALL_HEADER* PSP_CLASSINSTALL_HEADER;

struct SP_ENABLECLASS_PARAMS {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    GUID                   ClassGuid;
    DWORD                  EnableMessage;
}
alias SP_ENABLECLASS_PARAMS* PSP_ENABLECLASS_PARAMS;

struct SP_MOVEDEV_PARAMS {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    SP_DEVINFO_DATA        SourceDeviceInfoData;
}
alias SP_MOVEDEV_PARAMS* PSP_MOVEDEV_PARAMS;

struct SP_PROPCHANGE_PARAMS {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    DWORD                  StateChange;
    DWORD                  Scope;
    DWORD                  HwProfile;
}
alias SP_PROPCHANGE_PARAMS* PSP_PROPCHANGE_PARAMS;

struct SP_REMOVEDEVICE_PARAMS {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    DWORD                  Scope;
    DWORD                  HwProfile;
}
alias SP_REMOVEDEVICE_PARAMS* PSP_REMOVEDEVICE_PARAMS;

struct SP_UNREMOVEDEVICE_PARAMS {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    DWORD                  Scope;
    DWORD                  HwProfile;
}
alias SP_UNREMOVEDEVICE_PARAMS* PSP_UNREMOVEDEVICE_PARAMS;

struct SP_SELECTDEVICE_PARAMS_A {
    SP_CLASSINSTALL_HEADER    ClassInstallHeader;
    CHAR[MAX_TITLE_LEN]       Title = 0;
    CHAR[MAX_INSTRUCTION_LEN] Instructions = 0;
    CHAR[MAX_LABEL_LEN]       ListLabel = 0;
    CHAR[MAX_SUBTITLE_LEN]    SubTitle = 0;
    BYTE[2]                   Reserved;
}
alias SP_SELECTDEVICE_PARAMS_A* PSP_SELECTDEVICE_PARAMS_A;

struct SP_SELECTDEVICE_PARAMS_W {
    SP_CLASSINSTALL_HEADER     ClassInstallHeader;
    WCHAR[MAX_TITLE_LEN]       Title = 0;
    WCHAR[MAX_INSTRUCTION_LEN] Instructions = 0;
    WCHAR[MAX_LABEL_LEN]       ListLabel = 0;
    WCHAR[MAX_SUBTITLE_LEN]    SubTitle = 0;
}
alias SP_SELECTDEVICE_PARAMS_W* PSP_SELECTDEVICE_PARAMS_W;

extern(Windows) alias BOOL function(PVOID, DWORD) PDETECT_PROGRESS_NOTIFY;

struct SP_DETECTDEVICE_PARAMS {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    PDETECT_PROGRESS_NOTIFY DetectProgressNotify;
    PVOID                   ProgressNotifyParam;
}
alias SP_DETECTDEVICE_PARAMS* PSP_DETECTDEVICE_PARAMS;

struct SP_INSTALLWIZARD_DATA {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    DWORD                  Flags;
    HPROPSHEETPAGE[MAX_INSTALLWIZARD_DYNAPAGES] DynamicPages;
    DWORD                  NumDynamicPages;
    DWORD                  DynamicPageFlags;
    DWORD                  PrivateFlags;
    LPARAM                 PrivateData;
    HWND                   hwndWizardDlg;
}
alias SP_INSTALLWIZARD_DATA* PSP_INSTALLWIZARD_DATA;

struct SP_NEWDEVICEWIZARD_DATA {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    DWORD                  Flags;
    HPROPSHEETPAGE[MAX_INSTALLWIZARD_DYNAPAGES]  DynamicPages;
    DWORD                  NumDynamicPages;
    HWND                   hwndWizardDlg;
}
alias SP_NEWDEVICEWIZARD_DATA* PSP_NEWDEVICEWIZARD_DATA;
alias SP_NEWDEVICEWIZARD_DATA SP_ADDPROPERTYPAGE_DATA;
alias SP_NEWDEVICEWIZARD_DATA* PSP_ADDPROPERTYPAGE_DATA;

struct SP_TROUBLESHOOTER_PARAMS_A {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    CHAR[MAX_PATH]         ChmFile = 0;
    CHAR[MAX_PATH]         HtmlTroubleShooter = 0;
}
alias SP_TROUBLESHOOTER_PARAMS_A* PSP_TROUBLESHOOTER_PARAMS_A;

struct SP_TROUBLESHOOTER_PARAMS_W {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    WCHAR[MAX_PATH]        ChmFile = 0;
    WCHAR[MAX_PATH]        HtmlTroubleShooter = 0;
}
alias SP_TROUBLESHOOTER_PARAMS_W* PSP_TROUBLESHOOTER_PARAMS_W;

struct SP_POWERMESSAGEWAKE_PARAMS_A {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    CHAR[LINE_LEN*2]       PowerMessageWake = 0;
}
alias SP_POWERMESSAGEWAKE_PARAMS_A* PSP_POWERMESSAGEWAKE_PARAMS_A;

struct SP_POWERMESSAGEWAKE_PARAMS_W {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    WCHAR[LINE_LEN*2]      PowerMessageWake = 0;
}
alias SP_POWERMESSAGEWAKE_PARAMS_W* PSP_POWERMESSAGEWAKE_PARAMS_W;

mixin AlignedStr!(_alignVal, "SP_DRVINFO_DATA_V2_A", q{
    DWORD          cbSize = SP_DRVINFO_DATA_V2_A.sizeof;
    DWORD          DriverType;
    ULONG_PTR      Reserved;
    CHAR[LINE_LEN] Description = 0;
    CHAR[LINE_LEN] MfgName = 0;
    CHAR[LINE_LEN] ProviderName = 0;
    FILETIME       DriverDate;
    DWORDLONG      DriverVersion;
});
alias SP_DRVINFO_DATA_V2_A* PSP_DRVINFO_DATA_V2_A;

mixin AlignedStr!(_alignVal, "SP_DRVINFO_DATA_V2_W", q{
    DWORD           cbSize = SP_DRVINFO_DATA_V2_A.sizeof;
    DWORD           DriverType;
    ULONG_PTR       Reserved;
    WCHAR[LINE_LEN] Description = 0;
    WCHAR[LINE_LEN] MfgName = 0;
    WCHAR[LINE_LEN] ProviderName = 0;
    FILETIME        DriverDate;
    DWORDLONG       DriverVersion;
});
alias SP_DRVINFO_DATA_V2_W* PSP_DRVINFO_DATA_V2_W;

struct SP_DRVINFO_DATA_V1_A {
    DWORD          cbSize = SP_DRVINFO_DATA_V1_A.sizeof;
    DWORD          DriverType;
    ULONG_PTR      Reserved;
    CHAR[LINE_LEN] Description = 0;
    CHAR[LINE_LEN] MfgName = 0;
    CHAR[LINE_LEN] ProviderName = 0;
}
alias SP_DRVINFO_DATA_V1_A* PSP_DRVINFO_DATA_V1_A;

struct SP_DRVINFO_DATA_V1_W {
    DWORD           cbSize = SP_DRVINFO_DATA_V1_W.sizeof;
    DWORD           DriverType;
    ULONG_PTR       Reserved;
    WCHAR[LINE_LEN] Description = 0;
    WCHAR[LINE_LEN] MfgName = 0;
    WCHAR[LINE_LEN] ProviderName = 0;
}
alias SP_DRVINFO_DATA_V1_W* PSP_DRVINFO_DATA_V1_W;

version (Unicode) {
    alias SP_DRVINFO_DATA_V1_W SP_DRVINFO_DATA_V1;
    alias SP_DRVINFO_DATA_V2_W SP_DRVINFO_DATA_V2;
} else {
    alias SP_DRVINFO_DATA_V1_A SP_DRVINFO_DATA_V1;
    alias SP_DRVINFO_DATA_V2_A SP_DRVINFO_DATA_V2;
}
alias SP_DRVINFO_DATA_V1* PSP_DRVINFO_DATA_V1;
alias SP_DRVINFO_DATA_V2* PSP_DRVINFO_DATA_V2;

static if (USE_SP_DRVINFO_DATA_V1) {
    alias SP_DRVINFO_DATA_V1_A SP_DRVINFO_DATA_A;
    alias SP_DRVINFO_DATA_V1_A* PSP_DRVINFO_DATA_A;
    alias SP_DRVINFO_DATA_V1_W SP_DRVINFO_DATA_W;
    alias SP_DRVINFO_DATA_V1_W* PSP_DRVINFO_DATA_W;
    alias SP_DRVINFO_DATA_V1 SP_DRVINFO_DATA;
    alias SP_DRVINFO_DATA_V1* PSP_DRVINFO_DATA;
} else {
    alias SP_DRVINFO_DATA_V2_A SP_DRVINFO_DATA_A;
    alias SP_DRVINFO_DATA_V2_A* PSP_DRVINFO_DATA_A;
    alias SP_DRVINFO_DATA_V2_W SP_DRVINFO_DATA_W;
    alias SP_DRVINFO_DATA_V2_W* PSP_DRVINFO_DATA_W;
    alias SP_DRVINFO_DATA_V2 SP_DRVINFO_DATA;
    alias SP_DRVINFO_DATA_V2* PSP_DRVINFO_DATA;
}

extern(Windows) alias DWORD function(HDEVINFO, PSP_DEVINFO_DATA, PSP_DEVINFO_DATA, PVOID) PSP_DETSIG_CMPPROC;

mixin AlignedStr!(_alignVal, "SP_DRVINFO_DETAIL_DATA_A", q{
    DWORD          cbSize = SP_DRVINFO_DETAIL_DATA_A.sizeof;
    FILETIME       InfDate;
    DWORD          CompatIDsOffset;
    DWORD          CompatIDsLength;
    ULONG_PTR      Reserved;
    CHAR[LINE_LEN] SectionName = 0;
    CHAR[MAX_PATH] InfFileName = 0;
    CHAR[LINE_LEN] DrvDescription = 0;
    CHAR[1]        _HardwareID = 0;
    CHAR*          HardwareID() return { return _HardwareID.ptr; }
});
alias SP_DRVINFO_DETAIL_DATA_A* PSP_DRVINFO_DETAIL_DATA_A;

mixin AlignedStr!(_alignVal, "SP_DRVINFO_DETAIL_DATA_W", q{
    DWORD           cbSize = SP_DRVINFO_DETAIL_DATA_W.sizeof;
    FILETIME        InfDate;
    DWORD           CompatIDsOffset;
    DWORD           CompatIDsLength;
    ULONG_PTR       Reserved;
    WCHAR[LINE_LEN] SectionName = 0;
    WCHAR[MAX_PATH] InfFileName = 0;
    WCHAR[LINE_LEN] DrvDescription = 0;
    WCHAR[1]        _HardwareID = 0;
    WCHAR*          HardwareID() return { return _HardwareID.ptr; }
});
alias SP_DRVINFO_DETAIL_DATA_W* PSP_DRVINFO_DETAIL_DATA_W;

struct SP_DRVINSTALL_PARAMS {
    DWORD cbSize = SP_DRVINSTALL_PARAMS.sizeof;
    DWORD Rank;
    DWORD Flags;
    DWORD_PTR PrivateData;
    DWORD Reserved;
}
alias SP_DRVINSTALL_PARAMS* PSP_DRVINSTALL_PARAMS;

struct COINSTALLER_CONTEXT_DATA {
    BOOL  PostProcessing;
    DWORD InstallResult;
    PVOID PrivateData;
}
alias COINSTALLER_CONTEXT_DATA* PCOINSTALLER_CONTEXT_DATA;

struct SP_CLASSIMAGELIST_DATA {
    DWORD      cbSize = SP_CLASSIMAGELIST_DATA.sizeof;
    HIMAGELIST ImageList;
    ULONG_PTR  Reserved;
}
alias SP_CLASSIMAGELIST_DATA* PSP_CLASSIMAGELIST_DATA;

struct SP_PROPSHEETPAGE_REQUEST {
    DWORD            cbSize = SP_PROPSHEETPAGE_REQUEST.sizeof;
    DWORD            PageRequested;
    HDEVINFO         DeviceInfoSet;
    PSP_DEVINFO_DATA DeviceInfoData;
}
alias SP_PROPSHEETPAGE_REQUEST* PSP_PROPSHEETPAGE_REQUEST;

struct SP_BACKUP_QUEUE_PARAMS_A {
    DWORD cbSize = SP_BACKUP_QUEUE_PARAMS_A.sizeof;
    CHAR[MAX_PATH] FullInfPath = 0;
    INT FilenameOffset;
}
alias SP_BACKUP_QUEUE_PARAMS_A* PSP_BACKUP_QUEUE_PARAMS_A;

struct SP_BACKUP_QUEUE_PARAMS_W {
    DWORD cbSize = SP_BACKUP_QUEUE_PARAMS_W.sizeof;
    WCHAR[MAX_PATH] FullInfPath = 0;
    INT FilenameOffset;
}
alias SP_BACKUP_QUEUE_PARAMS_W* PSP_BACKUP_QUEUE_PARAMS_W;

version (Unicode) {
    alias SP_ORIGINAL_FILE_INFO_W SP_ORIGINAL_FILE_INFO;
    alias SP_ORIGINAL_FILE_INFO_W* PSP_ORIGINAL_FILE_INFO;
    alias FILEPATHS_W FILEPATHS;
    alias FILEPATHS_W* PFILEPATHS;
    alias SOURCE_MEDIA_W SOURCE_MEDIA;
    alias SOURCE_MEDIA_W* PSOURCE_MEDIA;
    alias CABINET_INFO_W CABINET_INFO;
    alias CABINET_INFO_W* PCABINET_INFO;
    alias FILE_IN_CABINET_INFO_W FILE_IN_CABINET_INFO;
    alias FILE_IN_CABINET_INFO_W* PFILE_IN_CABINET_INFO;
    alias SP_FILE_COPY_PARAMS_W SP_FILE_COPY_PARAMS;
    alias SP_FILE_COPY_PARAMS_W* PSP_FILE_COPY_PARAMS;
    alias SP_DEVICE_INTERFACE_DETAIL_DATA_W SP_DEVICE_INTERFACE_DETAIL_DATA;
    alias SP_DEVICE_INTERFACE_DETAIL_DATA_W* PSP_DEVICE_INTERFACE_DETAIL_DATA;
    deprecated {
        alias SP_DEVICE_INTERFACE_DETAIL_DATA_W SP_INTERFACE_DEVICE_DETAIL_DATA;
        alias SP_DEVICE_INTERFACE_DETAIL_DATA_W* PSP_INTERFACE_DEVICE_DETAIL_DATA;
    }
    alias SP_DEVINFO_LIST_DETAIL_DATA_W SP_DEVINFO_LIST_DETAIL_DATA;
    alias SP_DEVINFO_LIST_DETAIL_DATA_W *PSP_DEVINFO_LIST_DETAIL_DATA;
    alias SP_DEVINSTALL_PARAMS_W SP_DEVINSTALL_PARAMS;
    alias SP_DEVINSTALL_PARAMS_W* PSP_DEVINSTALL_PARAMS;
    alias SP_SELECTDEVICE_PARAMS_W SP_SELECTDEVICE_PARAMS;
    alias SP_SELECTDEVICE_PARAMS_W* PSP_SELECTDEVICE_PARAMS;
    alias SP_TROUBLESHOOTER_PARAMS_W SP_TROUBLESHOOTER_PARAMS;
    alias SP_TROUBLESHOOTER_PARAMS_W* PSP_TROUBLESHOOTER_PARAMS;
    alias SP_POWERMESSAGEWAKE_PARAMS_W SP_POWERMESSAGEWAKE_PARAMS;
    alias SP_POWERMESSAGEWAKE_PARAMS_W* PSP_POWERMESSAGEWAKE_PARAMS;
    alias SP_DRVINFO_DETAIL_DATA_W SP_DRVINFO_DETAIL_DATA;
    alias SP_DRVINFO_DETAIL_DATA_W* PSP_DRVINFO_DETAIL_DATA;
    alias SP_BACKUP_QUEUE_PARAMS_W SP_BACKUP_QUEUE_PARAMS;
    alias SP_BACKUP_QUEUE_PARAMS_W* PSP_BACKUP_QUEUE_PARAMS;
} else {
    alias SP_ORIGINAL_FILE_INFO_A SP_ORIGINAL_FILE_INFO;
    alias SP_ORIGINAL_FILE_INFO_A* PSP_ORIGINAL_FILE_INFO;
    alias FILEPATHS_A FILEPATHS;
    alias FILEPATHS_A* PFILEPATHS;
    alias SOURCE_MEDIA_A SOURCE_MEDIA;
    alias SOURCE_MEDIA_A* PSOURCE_MEDIA;
    alias CABINET_INFO_A CABINET_INFO;
    alias CABINET_INFO_A* PCABINET_INFO;
    alias FILE_IN_CABINET_INFO_A FILE_IN_CABINET_INFO;
    alias FILE_IN_CABINET_INFO_A* PFILE_IN_CABINET_INFO;
    alias SP_FILE_COPY_PARAMS_A SP_FILE_COPY_PARAMS;
    alias SP_FILE_COPY_PARAMS_A* PSP_FILE_COPY_PARAMS;
    alias SP_DEVICE_INTERFACE_DETAIL_DATA_A SP_DEVICE_INTERFACE_DETAIL_DATA;
    alias SP_DEVICE_INTERFACE_DETAIL_DATA_A* PSP_DEVICE_INTERFACE_DETAIL_DATA;
    deprecated {
        alias SP_DEVICE_INTERFACE_DETAIL_DATA_A SP_INTERFACE_DEVICE_DETAIL_DATA;
        alias SP_DEVICE_INTERFACE_DETAIL_DATA_A* PSP_INTERFACE_DEVICE_DETAIL_DATA;
    }
    alias SP_DEVINFO_LIST_DETAIL_DATA_A SP_DEVINFO_LIST_DETAIL_DATA;
    alias SP_DEVINFO_LIST_DETAIL_DATA_A* PSP_DEVINFO_LIST_DETAIL_DATA;
    alias SP_DEVINSTALL_PARAMS_A SP_DEVINSTALL_PARAMS;
    alias SP_DEVINSTALL_PARAMS_A* PSP_DEVINSTALL_PARAMS;
    alias SP_SELECTDEVICE_PARAMS_A SP_SELECTDEVICE_PARAMS;
    alias SP_SELECTDEVICE_PARAMS_A* PSP_SELECTDEVICE_PARAMS;
    alias SP_TROUBLESHOOTER_PARAMS_A SP_TROUBLESHOOTER_PARAMS;
    alias SP_TROUBLESHOOTER_PARAMS_A* PSP_TROUBLESHOOTER_PARAMS;
    alias SP_POWERMESSAGEWAKE_PARAMS_A SP_POWERMESSAGEWAKE_PARAMS;
    alias SP_POWERMESSAGEWAKE_PARAMS_A* PSP_POWERMESSAGEWAKE_PARAMS;
    alias SP_DRVINFO_DETAIL_DATA_A SP_DRVINFO_DETAIL_DATA;
    alias SP_DRVINFO_DETAIL_DATA_A* PSP_DRVINFO_DETAIL_DATA;
    alias SP_BACKUP_QUEUE_PARAMS_A SP_BACKUP_QUEUE_PARAMS;
    alias SP_BACKUP_QUEUE_PARAMS_A* PSP_BACKUP_QUEUE_PARAMS;
}

extern (Windows) {
    BOOL SetupAddInstallSectionToDiskSpaceListA(HDSKSPC, HINF, HINF, PCSTR, PVOID, UINT);
    BOOL SetupAddInstallSectionToDiskSpaceListW(HDSKSPC, HINF, HINF, PCWSTR, PVOID, UINT);
    BOOL SetupAddSectionToDiskSpaceListA(HDSKSPC, HINF, HINF, PCSTR, UINT, PVOID, UINT);
    BOOL SetupAddSectionToDiskSpaceListW(HDSKSPC, HINF, HINF, PCWSTR, UINT, PVOID, UINT);
    BOOL SetupAddToDiskSpaceListA(HDSKSPC, PCSTR, LONGLONG, UINT, PVOID, UINT);
    BOOL SetupAddToDiskSpaceListW(HDSKSPC, PCWSTR, LONGLONG, UINT, PVOID, UINT);
    BOOL SetupAddToSourceListA(DWORD, PCSTR);
    BOOL SetupAddToSourceListW(DWORD, PCWSTR);
    BOOL SetupQuerySourceListA(DWORD, PCSTR**List, PUINT);
    BOOL SetupQuerySourceListW(DWORD, PCWSTR**List, PUINT);
    BOOL SetupFreeSourceListA(PCSTR**List, UINT);
    BOOL SetupFreeSourceListW(PCWSTR**List, UINT);
    BOOL SetupAdjustDiskSpaceListA(HDSKSPC, LPCSTR, LONGLONG, PVOID, UINT);
    BOOL SetupAdjustDiskSpaceListW(HDSKSPC, LPCWSTR, LONGLONG, PVOID, UINT);
    UINT SetupBackupErrorA(HWND, PCSTR, PCSTR, PCSTR, UINT, DWORD);
    UINT SetupBackupErrorW(HWND, PCWSTR, PCWSTR, PCWSTR, UINT, DWORD);
    BOOL SetupCancelTemporary();
    BOOL SetupCloseFileQueue(HSPFILEQ);
    VOID SetupCloseInfFile(HINF);
    VOID SetupCloseLog();
    BOOL SetupCommitFileQueueA(HWND, HSPFILEQ, PSP_FILE_CALLBACK_A, PVOID);
    BOOL SetupCommitFileQueueW(HWND, HSPFILEQ, PSP_FILE_CALLBACK_W, PVOID);
    UINT SetupCopyErrorA(HWND, PCSTR, PCSTR, PCSTR, PCSTR, PCSTR, UINT, DWORD, PSTR, DWORD, PDWORD);
    UINT SetupCopyErrorW(HWND, PCWSTR, PCWSTR, PCWSTR, PCWSTR, PCWSTR, UINT, DWORD, PWSTR, DWORD, PDWORD);
    BOOL SetupCopyOEMInfA(PCSTR, PCSTR, DWORD, DWORD, PSTR, DWORD, PDWORD, PSTR*);
    BOOL SetupCopyOEMInfW(PCWSTR, PCWSTR, DWORD, DWORD, PWSTR, DWORD, PDWORD, PWSTR*);
    HDSKSPC SetupCreateDiskSpaceListA(PVOID, DWORD, UINT);
    HDSKSPC SetupCreateDiskSpaceListW(PVOID, DWORD, UINT);
    DWORD SetupDecompressOrCopyFileA(PCSTR, PCSTR, PUINT);
    DWORD SetupDecompressOrCopyFileW(PCWSTR, PCWSTR, PUINT);
    UINT SetupDefaultQueueCallbackA(PVOID, UINT, UINT_PTR, UINT_PTR);
    UINT SetupDefaultQueueCallbackW(PVOID, UINT, UINT_PTR, UINT_PTR);
    UINT SetupDeleteErrorA(HWND, PCSTR, PCSTR, UINT, DWORD);
    UINT SetupDeleteErrorW(HWND, PCWSTR, PCWSTR, UINT, DWORD);
    BOOL SetupDestroyDiskSpaceList(HDSKSPC);
    BOOL SetupDiAskForOEMDisk(HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiBuildClassInfoList(DWORD, LPGUID, DWORD, PDWORD);
    BOOL SetupDiBuildClassInfoListExA(DWORD, LPGUID, DWORD, PDWORD, PCSTR, PVOID);
    BOOL SetupDiBuildClassInfoListExW(DWORD, LPGUID, DWORD, PDWORD, PCWSTR, PVOID);
    BOOL SetupDiBuildDriverInfoList(HDEVINFO, PSP_DEVINFO_DATA, DWORD);
    BOOL SetupDiCallClassInstaller(DI_FUNCTION, HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiCancelDriverInfoSearch(HDEVINFO);
    BOOL SetupDiChangeState(HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiClassGuidsFromNameA(PCSTR, LPGUID, DWORD, PDWORD);
    BOOL SetupDiClassGuidsFromNameW(PCWSTR, LPGUID, DWORD, PDWORD);
    BOOL SetupDiClassGuidsFromNameExA(PCSTR, LPGUID, DWORD, PDWORD, PCSTR, PVOID);
    BOOL SetupDiClassGuidsFromNameExW(PCWSTR, LPGUID, DWORD, PDWORD, PCWSTR, PVOID);
    BOOL SetupDiClassNameFromGuidA(const(GUID)*, PSTR, DWORD, PDWORD);
    BOOL SetupDiClassNameFromGuidW(const(GUID)*, PWSTR, DWORD, PDWORD);
    BOOL SetupDiClassNameFromGuidExA(const(GUID)*, PSTR, DWORD, PDWORD, PCSTR, PVOID);
    BOOL SetupDiClassNameFromGuidExW(const(GUID)*, PWSTR, DWORD, PDWORD, PCWSTR, PVOID);
    BOOL SetupDiCreateDeviceInfoA(HDEVINFO, PCSTR, const(GUID)*, PCSTR, HWND, DWORD, PSP_DEVINFO_DATA);
    BOOL SetupDiCreateDeviceInfoW(HDEVINFO, PCWSTR, const(GUID)*, PCWSTR, HWND, DWORD, PSP_DEVINFO_DATA);
    HDEVINFO SetupDiCreateDeviceInfoList(const(GUID)*, HWND);
    HDEVINFO SetupDiCreateDeviceInfoListExA(const(GUID)*, HWND, PCSTR, PVOID);
    HDEVINFO SetupDiCreateDeviceInfoListExW(const(GUID)*, HWND, PCWSTR, PVOID);
    BOOL SetupDiCreateDeviceInterfaceA(HDEVINFO, PSP_DEVINFO_DATA, const(GUID)*, PCSTR, DWORD, PSP_DEVICE_INTERFACE_DATA);
    BOOL SetupDiCreateDeviceInterfaceW(HDEVINFO, PSP_DEVINFO_DATA, const(GUID)*, PCWSTR, DWORD, PSP_DEVICE_INTERFACE_DATA);
    HKEY SetupDiCreateDeviceInterfaceRegKeyA(HDEVINFO, PSP_DEVICE_INTERFACE_DATA, DWORD, REGSAM, HINF, PCSTR);
    HKEY SetupDiCreateDeviceInterfaceRegKeyW(HDEVINFO, PSP_DEVICE_INTERFACE_DATA, DWORD, REGSAM, HINF, PCWSTR);
    HKEY SetupDiCreateDevRegKeyA(HDEVINFO, PSP_DEVINFO_DATA, DWORD, DWORD, DWORD, HINF, PCSTR);
    HKEY SetupDiCreateDevRegKeyW(HDEVINFO, PSP_DEVINFO_DATA, DWORD, DWORD, DWORD, HINF, PCWSTR);
    BOOL SetupDiDeleteDeviceInfo(HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiDeleteDeviceInterfaceData(HDEVINFO, PSP_DEVICE_INTERFACE_DATA);
    BOOL SetupDiDeleteDeviceInterfaceRegKey(HDEVINFO, PSP_DEVICE_INTERFACE_DATA, DWORD);
    BOOL SetupDiDeleteDevRegKey(HDEVINFO, PSP_DEVINFO_DATA, DWORD, DWORD, DWORD);
    BOOL SetupDiDestroyClassImageList(PSP_CLASSIMAGELIST_DATA);
    BOOL SetupDiDestroyDeviceInfoList(HDEVINFO);
    BOOL SetupDiDestroyDriverInfoList(HDEVINFO, PSP_DEVINFO_DATA, DWORD);
    INT SetupDiDrawMiniIcon(HDC, RECT, INT, DWORD);
    BOOL SetupDiEnumDeviceInfo(HDEVINFO, DWORD, PSP_DEVINFO_DATA);
    BOOL SetupDiEnumDeviceInterfaces(HDEVINFO, PSP_DEVINFO_DATA, const(GUID)*, DWORD, PSP_DEVICE_INTERFACE_DATA);
    BOOL SetupDiEnumDriverInfoA(HDEVINFO, PSP_DEVINFO_DATA, DWORD, DWORD, PSP_DRVINFO_DATA_A);
    BOOL SetupDiEnumDriverInfoW(HDEVINFO, PSP_DEVINFO_DATA, DWORD, DWORD, PSP_DRVINFO_DATA_W);
    BOOL SetupDiGetActualSectionToInstallA(HINF, PCSTR, PSTR, DWORD, PDWORD, PSTR*);
    BOOL SetupDiGetActualSectionToInstallW(HINF, PCWSTR, PWSTR, DWORD, PDWORD, PWSTR*);
    BOOL SetupDiGetClassBitmapIndex(const(GUID)*, PINT);
    BOOL SetupDiGetClassDescriptionA(const(GUID)*, PSTR, DWORD, PDWORD);
    BOOL SetupDiGetClassDescriptionW(const(GUID)*, PWSTR, DWORD, PDWORD);
    BOOL SetupDiGetClassDescriptionExA(const(GUID)*, PSTR, DWORD, PDWORD, PCSTR, PVOID);
    BOOL SetupDiGetClassDescriptionExW(const(GUID)*, PWSTR, DWORD, PDWORD, PCWSTR, PVOID);
    BOOL SetupDiGetClassDevPropertySheetsA(HDEVINFO, PSP_DEVINFO_DATA, LPPROPSHEETHEADERA, DWORD, PDWORD, DWORD);
    BOOL SetupDiGetClassDevPropertySheetsW(HDEVINFO, PSP_DEVINFO_DATA, LPPROPSHEETHEADERW, DWORD, PDWORD, DWORD);
    HDEVINFO SetupDiGetClassDevsA(const(GUID)*, PCSTR, HWND, DWORD);
    HDEVINFO SetupDiGetClassDevsW(const(GUID)*, PCWSTR, HWND, DWORD);
    HDEVINFO SetupDiGetClassDevsExA(const(GUID)*, PCSTR, HWND, DWORD, HDEVINFO, PCSTR, PVOID);
    HDEVINFO SetupDiGetClassDevsExW(const(GUID)*, PCWSTR, HWND, DWORD, HDEVINFO, PCWSTR, PVOID);
    BOOL SetupDiGetClassImageIndex(PSP_CLASSIMAGELIST_DATA, const(GUID)*, PINT);
    BOOL SetupDiGetClassImageList(PSP_CLASSIMAGELIST_DATA);
    BOOL SetupDiGetClassImageListExA(PSP_CLASSIMAGELIST_DATA, PCSTR, PVOID);
    BOOL SetupDiGetClassImageListExW(PSP_CLASSIMAGELIST_DATA, PCWSTR, PVOID);
    BOOL SetupDiGetClassInstallParamsA(HDEVINFO, PSP_DEVINFO_DATA, PSP_CLASSINSTALL_HEADER, DWORD, PDWORD);
    BOOL SetupDiGetClassInstallParamsW(HDEVINFO, PSP_DEVINFO_DATA, PSP_CLASSINSTALL_HEADER, DWORD, PDWORD);
    BOOL SetupDiGetClassRegistryPropertyA(LPGUID, DWORD, PDWORD, PBYTE, DWORD, PDWORD, PCSTR, PVOID);
    BOOL SetupDiGetClassRegistryPropertyW(LPGUID, DWORD, PDWORD, PBYTE, DWORD, PDWORD, PCWSTR, PVOID);
    BOOL SetupDiGetDeviceInfoListClass(HDEVINFO, LPGUID);
    BOOL SetupDiGetDeviceInfoListDetailA(HDEVINFO, PSP_DEVINFO_LIST_DETAIL_DATA_A);
    BOOL SetupDiGetDeviceInfoListDetailW(HDEVINFO, PSP_DEVINFO_LIST_DETAIL_DATA_W);
    BOOL SetupDiGetDeviceInstallParamsA(HDEVINFO, PSP_DEVINFO_DATA, PSP_DEVINSTALL_PARAMS_A);
    BOOL SetupDiGetDeviceInstallParamsW(HDEVINFO, PSP_DEVINFO_DATA, PSP_DEVINSTALL_PARAMS_W);
    BOOL SetupDiGetDeviceInstanceIdA(HDEVINFO, PSP_DEVINFO_DATA, PSTR, DWORD, PDWORD);
    BOOL SetupDiGetDeviceInstanceIdW(HDEVINFO, PSP_DEVINFO_DATA, PWSTR, DWORD, PDWORD);
    BOOL SetupDiGetDeviceInterfaceAlias(HDEVINFO, PSP_DEVICE_INTERFACE_DATA, const(GUID)*, PSP_DEVICE_INTERFACE_DATA);
    BOOL SetupDiGetDeviceInterfaceDetailA(HDEVINFO, PSP_DEVICE_INTERFACE_DATA, PSP_DEVICE_INTERFACE_DETAIL_DATA_A, DWORD, PDWORD, PSP_DEVINFO_DATA);
    BOOL SetupDiGetDeviceInterfaceDetailW(HDEVINFO, PSP_DEVICE_INTERFACE_DATA, PSP_DEVICE_INTERFACE_DETAIL_DATA_W, DWORD, PDWORD, PSP_DEVINFO_DATA);
    BOOL SetupDiGetDeviceRegistryPropertyA(HDEVINFO, PSP_DEVINFO_DATA, DWORD, PDWORD, PBYTE, DWORD, PDWORD);
    BOOL SetupDiGetDeviceRegistryPropertyW(HDEVINFO, PSP_DEVINFO_DATA, DWORD, PDWORD, PBYTE, DWORD, PDWORD);
    BOOL SetupDiGetDriverInfoDetailA(HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_A, PSP_DRVINFO_DETAIL_DATA_A, DWORD, PDWORD);
    BOOL SetupDiGetDriverInfoDetailW(HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_W, PSP_DRVINFO_DETAIL_DATA_W, DWORD, PDWORD);
    BOOL SetupDiGetDriverInstallParamsA(HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_A, PSP_DRVINSTALL_PARAMS);
    BOOL SetupDiGetDriverInstallParamsW(HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_W, PSP_DRVINSTALL_PARAMS);
    BOOL SetupDiGetHwProfileFriendlyNameA(DWORD, PSTR, DWORD, PDWORD);
    BOOL SetupDiGetHwProfileFriendlyNameExA(DWORD, PSTR, DWORD, PDWORD, PCSTR, PVOID);
    BOOL SetupDiGetHwProfileFriendlyNameExW(DWORD, PWSTR, DWORD, PDWORD, PCWSTR, PVOID);
    BOOL SetupDiGetHwProfileFriendlyNameW(DWORD, PWSTR, DWORD, PDWORD);
    BOOL SetupDiGetHwProfileList(PDWORD, DWORD, PDWORD, PDWORD);
    BOOL SetupDiGetHwProfileListExA(PDWORD, DWORD, PDWORD, PDWORD, PCSTR, PVOID);
    BOOL SetupDiGetHwProfileListExW(PDWORD, DWORD, PDWORD, PDWORD, PCWSTR, PVOID);
    BOOL SetupDiGetINFClassA(PCSTR, LPGUID, PSTR, DWORD, PDWORD);
    BOOL SetupDiGetINFClassW(PCWSTR, LPGUID, PWSTR, DWORD, PDWORD);
    BOOL SetupDiGetSelectedDevice(HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiGetSelectedDriverA(HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_A);
    BOOL SetupDiGetSelectedDriverW(HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_W);
    HPROPSHEETPAGE SetupDiGetWizardage(HDEVINFO, PSP_DEVINFO_DATA, PSP_INSTALLWIZARD_DATA, DWORD, DWORD);
    BOOL SetupDiInstallClassA(HWND, PCSTR, DWORD, HSPFILEQ);
    BOOL SetupDiInstallClassW(HWND, PCWSTR, DWORD, HSPFILEQ);
    BOOL SetupDiInstallClassExA(HWND, PCSTR, DWORD, HSPFILEQ, const(GUID)*, PVOID, PVOID);
    BOOL SetupDiInstallClassExW(HWND, PCWSTR, DWORD, HSPFILEQ, const(GUID)*, PVOID, PVOID);
    BOOL SetupDiInstallDevice(HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiInstallDeviceInterfaces(HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiInstallDriverFiles(HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiLoadClassIcon(const(GUID)*, HICON*, PINT);
    BOOL SetupDiMoveDuplicateDevice(HDEVINFO, PSP_DEVINFO_DATA);
    HKEY SetupDiOpenClassRegKey(const(GUID)*, REGSAM);
    HKEY SetupDiOpenClassRegKeyExA(const(GUID)*, REGSAM, DWORD, PCSTR, PVOID);
    HKEY SetupDiOpenClassRegKeyExW(const(GUID)*, REGSAM, DWORD, PCWSTR, PVOID);
    BOOL SetupDiOpenDeviceInfoA(HDEVINFO, PCSTR, HWND, DWORD, PSP_DEVINFO_DATA);
    BOOL SetupDiOpenDeviceInfoW(HDEVINFO, PCWSTR, HWND, DWORD, PSP_DEVINFO_DATA);
    BOOL SetupDiOpenDeviceInterfaceA(HDEVINFO, PCSTR, DWORD, PSP_DEVICE_INTERFACE_DATA);
    BOOL SetupDiOpenDeviceInterfaceW(HDEVINFO, PCWSTR, DWORD, PSP_DEVICE_INTERFACE_DATA);
    HKEY SetupDiOpenDeviceInterfaceRegKey(HDEVINFO, PSP_DEVICE_INTERFACE_DATA, DWORD, REGSAM);
    HKEY SetupDiOpenDevRegKey(HDEVINFO, PSP_DEVINFO_DATA, DWORD, DWORD, DWORD, REGSAM);
    BOOL SetupDiRegisterCoDeviceInstallers(HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiRegisterDeviceInfo(HDEVINFO, PSP_DEVINFO_DATA, DWORD, PSP_DETSIG_CMPPROC, PVOID, PSP_DEVINFO_DATA);
    BOOL SetupDiRemoveDevice(HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiRemoveDeviceInterface(HDEVINFO, PSP_DEVICE_INTERFACE_DATA);
    BOOL SetupDiSelectBestCompatDrv(HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiSelectDevice(HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiSelectOEMDrv(HWND, HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiSetClassInstallParamsA(HDEVINFO, PSP_DEVINFO_DATA, PSP_CLASSINSTALL_HEADER, DWORD);
    BOOL SetupDiSetClassInstallParamsW(HDEVINFO, PSP_DEVINFO_DATA, PSP_CLASSINSTALL_HEADER, DWORD);
    BOOL SetupDiSetClassRegistryPropertyA(LPGUID, DWORD, const(BYTE)*, DWORD, PCSTR, PVOID);
    BOOL SetupDiSetClassRegistryPropertyW(LPGUID, DWORD, const(BYTE)*, DWORD, PCWSTR, PVOID);
    BOOL SetupDiSetDeviceInstallParamsA(HDEVINFO, PSP_DEVINFO_DATA, PSP_DEVINSTALL_PARAMS_A);
    BOOL SetupDiSetDeviceInstallParamsW(HDEVINFO, PSP_DEVINFO_DATA, PSP_DEVINSTALL_PARAMS_W);
    BOOL SetupDiSetDeviceRegistryPropertyA(HDEVINFO, PSP_DEVINFO_DATA, DWORD, const(BYTE)*, DWORD);
    BOOL SetupDiSetDeviceRegistryPropertyW(HDEVINFO, PSP_DEVINFO_DATA, DWORD, const(BYTE)*, DWORD);
    BOOL SetupDiSetDriverInstallParamsA(HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_A, PSP_DRVINSTALL_PARAMS);
    BOOL SetupDiSetDriverInstallParamsW(HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_W, PSP_DRVINSTALL_PARAMS);
    BOOL SetupDiSetSelectedDevice(HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupDiSetSelectedDriverA(HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_A);
    BOOL SetupDiSetSelectedDriverW(HDEVINFO, PSP_DEVINFO_DATA, PSP_DRVINFO_DATA_W);
    BOOL SetupDiUnremoveDevice(HDEVINFO, PSP_DEVINFO_DATA);
    HDSKSPC SetupDuplicateDiskSpaceListA(HDSKSPC, PVOID, DWORD, UINT);
    HDSKSPC SetupDuplicateDiskSpaceListW(HDSKSPC, PVOID, DWORD, UINT);
    BOOL SetupFindFirstLineA(HINF, PCSTR, PCSTR, PINFCONTEXT);
    BOOL SetupFindFirstLineW(HINF, PCWSTR, PCWSTR, PINFCONTEXT);
    BOOL SetupFindNextLine(PINFCONTEXT, PINFCONTEXT);
    BOOL SetupFindNextMatchLineA(PINFCONTEXT, PCSTR, PINFCONTEXT);
    BOOL SetupFindNextMatchLineW(PINFCONTEXT, PCWSTR, PINFCONTEXT);
    BOOL SetupFreeA(PCSTR**, UINT);
    BOOL SetupFreeW(PCWSTR**, UINT);
    BOOL SetupGetBackupInformationA(HSPFILEQ, PSP_BACKUP_QUEUE_PARAMS_A);
    BOOL SetupGetBackupInformationW(HSPFILEQ, PSP_BACKUP_QUEUE_PARAMS_W);
    BOOL SetupGetBinaryField(PINFCONTEXT, DWORD, PBYTE, DWORD, LPDWORD);
    DWORD SetupGetFieldCount(PINFCONTEXT);
    DWORD SetupGetFileCompressionInfoA(PCSTR, PSTR*, PDWORD, PDWORD, PUINT);
    DWORD SetupGetFileCompressionInfoW(PCWSTR, PWSTR*, PDWORD, PDWORD, PUINT);
    BOOL SetupGetInfFileListA(PCSTR, DWORD, PSTR, DWORD, PDWORD);
    BOOL SetupGetInfFileListW(PCWSTR, DWORD, PWSTR, DWORD, PDWORD);
    BOOL SetupGetInfInformationA(LPCVOID, DWORD, PSP_INF_INFORMATION, DWORD, PDWORD);
    BOOL SetupGetInfInformationW(LPCVOID, DWORD, PSP_INF_INFORMATION, DWORD, PDWORD);
    BOOL SetupGetIntField(PINFCONTEXT, DWORD, PINT);
    BOOL SetupGetLineByIndexA(HINF, PCSTR, DWORD, PINFCONTEXT);
    BOOL SetupGetLineByIndexW(HINF, PCWSTR, DWORD, PINFCONTEXT);
    LONG SetupGetLineCountA(HINF, PCSTR);
    LONG SetupGetLineCountW(HINF, PCWSTR);
    BOOL SetupGetLineTextA(PINFCONTEXT, HINF, PCSTR, PCSTR, PSTR, DWORD, PDWORD);
    BOOL SetupGetLineTextW(PINFCONTEXT, HINF, PCWSTR, PCWSTR, PWSTR, DWORD, PDWORD);
    BOOL SetupGetMultiSzFieldA(PINFCONTEXT, DWORD, PSTR, DWORD, LPDWORD);
    BOOL SetupGetMultiSzFieldW(PINFCONTEXT, DWORD, PWSTR, DWORD, LPDWORD);
    BOOL SetupGetSourceFileLocationA(HINF, PINFCONTEXT, PCSTR, PUINT, PSTR, DWORD, PDWORD);
    BOOL SetupGetSourceFileLocationW(HINF, PINFCONTEXT, PCWSTR, PUINT, PWSTR, DWORD, PDWORD);
    BOOL SetupGetSourceFileSizeA(HINF, PINFCONTEXT, PCSTR, PCSTR, PDWORD, UINT);
    BOOL SetupGetSourceFileSizeW(HINF, PINFCONTEXT, PCWSTR, PCWSTR, PDWORD, UINT);
    BOOL SetupGetSourceInfoA(HINF, UINT, UINT, PSTR, DWORD, PDWORD);
    BOOL SetupGetSourceInfoW(HINF, UINT, UINT, PWSTR, DWORD, PDWORD);
    BOOL SetupGetStringFieldA(PINFCONTEXT, DWORD, PSTR, DWORD, PDWORD);
    BOOL SetupGetStringFieldW(PINFCONTEXT, DWORD, PWSTR, DWORD, PDWORD);
    BOOL SetupGetTargetPathA(HINF, PINFCONTEXT, PCSTR, PSTR, DWORD, PDWORD);
    BOOL SetupGetTargetPathW(HINF, PINFCONTEXT, PCWSTR, PWSTR, DWORD, PDWORD);
    PVOID SetupInitDefaultQueueCallback(HWND);
    PVOID SetupInitDefaultQueueCallbackEx(HWND, HWND, UINT, DWORD, PVOID);
    HSPFILELOG SetupInitializeFileLogA(PCSTR, DWORD);
    HSPFILELOG SetupInitializeFileLogW(PCWSTR, DWORD);
    BOOL SetupInstallFileA(HINF, PINFCONTEXT, PCSTR, PCSTR, PCSTR, DWORD, PSP_FILE_CALLBACK_A, PVOID);
    BOOL SetupInstallFileW(HINF, PINFCONTEXT, PCWSTR, PCWSTR, PCWSTR, DWORD, PSP_FILE_CALLBACK_W, PVOID);
    BOOL SetupInstallFileExA(HINF, PINFCONTEXT, PCSTR, PCSTR, PCSTR, DWORD, PSP_FILE_CALLBACK_A, PVOID, PBOOL);
    BOOL SetupInstallFileExW(HINF, PINFCONTEXT, PCWSTR, PCWSTR, PCWSTR, DWORD, PSP_FILE_CALLBACK_W, PVOID, PBOOL);
    BOOL SetupInstallFilesFromInfSectionA(HINF, HINF, HSPFILEQ, PCSTR, PCSTR, UINT);
    BOOL SetupInstallFilesFromInfSectionW(HINF, HINF, HSPFILEQ, PCWSTR, PCWSTR, UINT);
    BOOL SetupInstallFromInfSectionA(HWND, HINF, PCSTR, UINT, HKEY, PCSTR, UINT, PSP_FILE_CALLBACK_A, PVOID, HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupInstallFromInfSectionW(HWND, HINF, PCWSTR, UINT, HKEY, PCWSTR, UINT, PSP_FILE_CALLBACK_W, PVOID, HDEVINFO, PSP_DEVINFO_DATA);
    BOOL SetupInstallServicesFromInfSectionA(HINF, PCSTR, DWORD);
    BOOL SetupInstallServicesFromInfSectionW(HINF, PCWSTR, DWORD);
    BOOL SetupInstallServicesFromInfSectionExA(HINF, PCSTR, DWORD, HDEVINFO, PSP_DEVINFO_DATA, PVOID, PVOID);
    BOOL SetupInstallServicesFromInfSectionExW(HINF, PCWSTR, DWORD, HDEVINFO, PSP_DEVINFO_DATA, PVOID, PVOID);
    BOOL SetupIterateCabinetA(PCSTR, DWORD, PSP_FILE_CALLBACK_A, PVOID);
    BOOL SetupIterateCabinetW(PCWSTR, DWORD, PSP_FILE_CALLBACK_W, PVOID);
    BOOL SetupLogErrorA(LPCSTR, LogSeverity);
    BOOL SetupLogErrorW(LPCWSTR, LogSeverity);
    BOOL SetupLogFileA(HSPFILELOG, PCSTR, PCSTR, PCSTR, DWORD, PCSTR, PCSTR, PCSTR, DWORD);
    BOOL SetupLogFileW(HSPFILELOG, PCWSTR, PCWSTR, PCWSTR, DWORD, PCWSTR, PCWSTR, PCWSTR, DWORD);
    BOOL SetupOpenAppendInfFileA(PCSTR, HINF, PUINT);
    BOOL SetupOpenAppendInfFileW(PCWSTR, HINF, PUINT);
    HSPFILEQ SetupOpenFileQueue();
    HINF SetupOpenInfFileA(PCSTR, PCSTR, DWORD, PUINT);
    HINF SetupOpenInfFileW(PCWSTR, PCWSTR, DWORD, PUINT);
    BOOL SetupOpenLog(BOOL);
    HINF SetupOpenMasterInf();
    UINT SetupPromptForDiskA(HWND, PCSTR, PCSTR, PCSTR, PCSTR, PCSTR, DWORD, PSTR, DWORD, PDWORD);
    UINT SetupPromptForDiskW(HWND, PCWSTR, PCWSTR, PCWSTR, PCWSTR, PCWSTR, DWORD, PWSTR, DWORD, PDWORD);
    INT SetupPromptReboot(HSPFILEQ, HWND, BOOL);
    BOOL SetupQueryA(DWORD, PCSTR**, PUINT);
    BOOL SetupQueryW(DWORD, PCWSTR**, PUINT);
    BOOL SetupQueryDrivesInDiskSpaceListA(HDSKSPC, PSTR, DWORD, PDWORD);
    BOOL SetupQueryDrivesInDiskSpaceListW(HDSKSPC, PWSTR, DWORD, PDWORD);
    BOOL SetupQueryFileLogA(HSPFILELOG, PCSTR, PCSTR, SetupFileLogInfo, PSTR, DWORD, PDWORD);
    BOOL SetupQueryFileLogW(HSPFILELOG, PCWSTR, PCWSTR, SetupFileLogInfo, PWSTR, DWORD, PDWORD);
    BOOL SetupQueryInfFileInformationA(PSP_INF_INFORMATION, UINT, PSTR, DWORD, PDWORD);
    BOOL SetupQueryInfFileInformationW(PSP_INF_INFORMATION, UINT, PWSTR, DWORD, PDWORD);
    BOOL SetupQueryInfOriginalFileInformationA(PSP_INF_INFORMATION, UINT, PSP_ALTPLATFORM_INFO, PSP_ORIGINAL_FILE_INFO_A);
    BOOL SetupQueryInfOriginalFileInformationW(PSP_INF_INFORMATION, UINT, PSP_ALTPLATFORM_INFO, PSP_ORIGINAL_FILE_INFO_W);
    BOOL SetupQueryInfVersionInformationA(PSP_INF_INFORMATION, UINT, PSTR, PSTR, DWORD, PDWORD);
    BOOL SetupQueryInfVersionInformationW(PSP_INF_INFORMATION, UINT, PCWSTR, PWSTR, DWORD, PDWORD);
    BOOL SetupQuerySpaceRequiredOnDriveA(HDSKSPC, PCSTR, LONGLONG*, PVOID, UINT);
    BOOL SetupQuerySpaceRequiredOnDriveW(HDSKSPC, PCWSTR, LONGLONG*, PVOID, UINT);
    BOOL SetupQueueCopyA(HSPFILEQ, PCSTR, PCSTR, PCSTR, PCSTR, PCSTR, PCSTR, PCSTR, DWORD);
    BOOL SetupQueueCopyW(HSPFILEQ, PCWSTR, PCWSTR, PCWSTR, PCWSTR, PCWSTR, PCWSTR, PCWSTR, DWORD);
    BOOL SetupQueueCopyIndirectA(PSP_FILE_COPY_PARAMS_A);
    BOOL SetupQueueCopyIndirectW(PSP_FILE_COPY_PARAMS_W);
    BOOL SetupQueueCopySectionA(HSPFILEQ, PCSTR, HINF, HINF, PCSTR, DWORD);
    BOOL SetupQueueCopySectionW(HSPFILEQ, PCWSTR, HINF, HINF, PCWSTR, DWORD);
    BOOL SetupQueueDefaultCopyA(HSPFILEQ, HINF, PCSTR, PCSTR, PCSTR, DWORD);
    BOOL SetupQueueDefaultCopyW(HSPFILEQ, HINF, PCWSTR, PCWSTR, PCWSTR, DWORD);
    BOOL SetupQueueDeleteA(HSPFILEQ, PCSTR, PCSTR);
    BOOL SetupQueueDeleteW(HSPFILEQ, PCWSTR, PCWSTR);
    BOOL SetupQueueDeleteSectionA(HSPFILEQ, HINF, HINF, PCSTR);
    BOOL SetupQueueDeleteSectionW(HSPFILEQ, HINF, HINF, PCWSTR);
    BOOL SetupQueueRenameA(HSPFILEQ, PCSTR, PCSTR, PCSTR, PCSTR);
    BOOL SetupQueueRenameW(HSPFILEQ, PCWSTR, PCWSTR, PCWSTR, PCWSTR);
    BOOL SetupQueueRenameSectionA(HSPFILEQ, HINF, HINF, PCSTR);
    BOOL SetupQueueRenameSectionW(HSPFILEQ, HINF, HINF, PCWSTR);
    BOOL SetupRemoveFileLogEntryA(HSPFILELOG, PCSTR, PCSTR);
    BOOL SetupRemoveFileLogEntryW(HSPFILELOG, PCWSTR, PCWSTR);
    BOOL SetupRemoveFromDiskSpaceListA(HDSKSPC, PCSTR, UINT, PVOID, UINT);
    BOOL SetupRemoveFromDiskSpaceListW(HDSKSPC, PCWSTR, UINT, PVOID, UINT);
    BOOL SetupRemoveFromSourceListA(DWORD, PCSTR);
    BOOL SetupRemoveFromSourceListW(DWORD, PCWSTR);
    BOOL SetupRemoveInstallSectionFromDiskSpaceListA(HDSKSPC, HINF, HINF, PCSTR, PVOID, UINT);
    BOOL SetupRemoveInstallSectionFromDiskSpaceListW(HDSKSPC, HINF, HINF, PCWSTR, PVOID, UINT);
    BOOL SetupRemoveSectionFromDiskSpaceListA(HDSKSPC, HINF, HINF, PCSTR, UINT, PVOID, UINT);
    BOOL SetupRemoveSectionFromDiskSpaceListW(HDSKSPC, HINF, HINF, PCWSTR, UINT, PVOID, UINT);
    UINT SetupRenameErrorA(HWND, PCSTR, PCSTR, PCSTR, UINT, DWORD);
    UINT SetupRenameErrorW(HWND, PCWSTR, PCWSTR, PCWSTR, UINT, DWORD);
    BOOL SetupScanFileQueueA(HSPFILEQ, DWORD, HWND, PSP_FILE_CALLBACK_A, PVOID, PDWORD);
    BOOL SetupScanFileQueueW(HSPFILEQ, DWORD, HWND, PSP_FILE_CALLBACK_W, PVOID, PDWORD);
    BOOL SetupSetDirectoryIdA(HINF, DWORD, PCSTR);
    BOOL SetupSetDirectoryIdW(HINF, DWORD, PCWSTR);
    BOOL SetupSetDirectoryIdExA(HINF, DWORD, PCSTR, DWORD, DWORD, PVOID);
    BOOL SetupSetDirectoryIdExW(HINF, DWORD, PCWSTR, DWORD, DWORD, PVOID);
    BOOL SetupSetFileQueueAlternatePlatformA(HSPFILEQ, PSP_ALTPLATFORM_INFO, PCSTR);
    BOOL SetupSetFileQueueAlternatePlatformW(HSPFILEQ, PSP_ALTPLATFORM_INFO, PCWSTR);
    BOOL SetupSetPlatformPathOverrideA(PCSTR);
    BOOL SetupSetPlatformPathOverrideW(PCWSTR);
    BOOL SetupSetSourceListA(DWORD, PCSTR*, UINT);
    BOOL SetupSetSourceListW(DWORD, PCWSTR*, UINT);
    VOID SetupTermDefaultQueueCallback(PVOID);
    BOOL SetupTerminateFileLog(HSPFILELOG);
}

deprecated {
    alias SetupDiCreateDeviceInterfaceW SetupDiCreateInterfaceDeviceW;
    alias SetupDiCreateDeviceInterfaceRegKeyW SetupDiCreateInterfaceDeviceRegKeyW;
    alias SetupDiOpenDeviceInterfaceW SetupDiOpenInterfaceDeviceW;
    alias SetupDiGetDeviceInterfaceDetailW SetupDiGetInterfaceDeviceDetailW;
    alias SetupDiCreateDeviceInterfaceA SetupDiCreateInterfaceDeviceA;
    alias SetupDiCreateDeviceInterfaceRegKeyA SetupDiCreateInterfaceDeviceRegKeyA;
    alias SetupDiOpenDeviceInterfaceA SetupDiOpenInterfaceDeviceA;
    alias SetupDiGetDeviceInterfaceDetailA SetupDiGetInterfaceDeviceDetailA;
}

version (Unicode) {
    alias PSP_FILE_CALLBACK_W PSP_FILE_CALLBACK;
    alias SetupAddInstallSectionToDiskSpaceListW SetupAddInstallSectionToDiskSpaceList;
    alias SetupAddSectionToDiskSpaceListW SetupAddSectionToDiskSpaceList;
    alias SetupAddToDiskSpaceListW SetupAddToDiskSpaceList;
    alias SetupAddToSourceListW SetupAddToSourceList;
    alias SetupAdjustDiskSpaceListW SetupAdjustDiskSpaceList;
    alias SetupBackupErrorW SetupBackupError;
    alias SetupCommitFileQueueW SetupCommitFileQueue;
    alias SetupCopyErrorW SetupCopyError;
    alias SetupCopyOEMInfW SetupCopyOEMInf;
    alias SetupCreateDiskSpaceListW SetupCreateDiskSpaceList;
    alias SetupDecompressOrCopyFileW SetupDecompressOrCopyFile;
    alias SetupDefaultQueueCallbackW SetupDefaultQueueCallback;
    alias SetupDeleteErrorW SetupDeleteError;
    alias SetupDiBuildClassInfoListExW SetupDiBuildClassInfoListEx;
    alias SetupDiClassGuidsFromNameExW SetupDiClassGuidsFromNameEx;
    alias SetupDiClassGuidsFromNameW SetupDiClassGuidsFromName;
    alias SetupDiClassNameFromGuidExW SetupDiClassNameFromGuidEx;
    alias SetupDiClassNameFromGuidW SetupDiClassNameFromGuid;
    alias SetupDiCreateDeviceInfoListExW SetupDiCreateDeviceInfoListEx;
    alias SetupDiCreateDeviceInfoW SetupDiCreateDeviceInfo;
    alias SetupDiCreateDeviceInterfaceRegKeyW SetupDiCreateDeviceInterfaceRegKey;
    deprecated alias SetupDiCreateDeviceInterfaceRegKeyW SetupDiCreateInterfaceDeviceRegKey;
    alias SetupDiCreateDeviceInterfaceW SetupDiCreateDeviceInterface;
    deprecated alias SetupDiCreateDeviceInterfaceW SetupDiCreateInterfaceDevice;
    alias SetupDiCreateDevRegKeyW SetupDiCreateDevRegKey;
    alias SetupDiEnumDriverInfoW SetupDiEnumDriverInfo;
    alias SetupDiGetActualSectionToInstallW SetupDiGetActualSectionToInstall;
    alias SetupDiGetClassDescriptionExW SetupDiGetClassDescriptionEx;
    alias SetupDiGetClassDescriptionW SetupDiGetClassDescription;
    alias SetupDiGetClassDevPropertySheetsW SetupDiGetClassDevPropertySheets;
    alias SetupDiGetClassDevsExW SetupDiGetClassDevsEx;
    alias SetupDiGetClassDevsW SetupDiGetClassDevs;
    alias SetupDiGetClassImageListExW SetupDiGetClassImageListEx;
    alias SetupDiGetClassInstallParamsW SetupDiGetClassInstallParams;
    alias SetupDiGetClassRegistryPropertyW SetupDiGetClassRegistryProperty;
    alias SetupDiGetDeviceInfoListDetailW SetupDiGetDeviceInfoListDetail;
    alias SetupDiGetDeviceInstallParamsW SetupDiGetDeviceInstallParams;
    alias SetupDiGetDeviceInstanceIdW SetupDiGetDeviceInstanceId;
    alias SetupDiGetDeviceInterfaceDetailW SetupDiGetDeviceInterfaceDetail;
    deprecated alias SetupDiGetDeviceInterfaceDetailW SetupDiGetInterfaceDeviceDetail;
    alias SetupDiGetDeviceRegistryPropertyW SetupDiGetDeviceRegistryProperty;
    alias SetupDiGetDriverInfoDetailW SetupDiGetDriverInfoDetail;
    alias SetupDiGetDriverInstallParamsW SetupDiGetDriverInstallParams;
    alias SetupDiGetHwProfileFriendlyNameExW SetupDiGetHwProfileFriendlyNameEx;
    alias SetupDiGetHwProfileFriendlyNameW SetupDiGetHwProfileFriendlyName;
    alias SetupDiGetHwProfileListExW SetupDiGetHwProfileListEx;
    alias SetupDiGetINFClassW SetupDiGetINFClass;
    alias SetupDiGetSelectedDriverW SetupDiGetSelectedDriver;
    alias SetupDiInstallClassExW SetupDiInstallClassEx;
    alias SetupDiInstallClassW SetupDiInstallClass;
    alias SetupDiOpenClassRegKeyExW SetupDiOpenClassRegKeyEx;
    alias SetupDiOpenDeviceInfoW SetupDiOpenDeviceInfo;
    alias SetupDiOpenDeviceInterfaceW SetupDiOpenDeviceInterface;
    deprecated alias SetupDiOpenDeviceInterfaceW SetupDiOpenInterfaceDevice;
    alias SetupDiSetClassInstallParamsW SetupDiSetClassInstallParams;
    alias SetupDiSetClassRegistryPropertyW SetupDiSetClassRegistryProperty;
    alias SetupDiSetDeviceInstallParamsW SetupDiSetDeviceInstallParams;
    alias SetupDiSetDeviceRegistryPropertyW SetupDiSetDeviceRegistryProperty;
    alias SetupDiSetDriverInstallParamsW SetupDiSetDriverInstallParams;
    alias SetupDiSetSelectedDriverW SetupDiSetSelectedDriver;
    alias SetupDuplicateDiskSpaceListW SetupDuplicateDiskSpaceList;
    alias SetupFindFirstLineW SetupFindFirstLine;
    alias SetupFindNextMatchLineW SetupFindNextMatchLine;
    alias SetupFreeSourceListW SetupFreeSourceList;
    alias SetupGetBackupInformationW SetupGetBackupInformation;
    alias SetupGetFileCompressionInfoW SetupGetFileCompressionInfo;
    alias SetupGetInfFileListW SetupGetInfFileList;
    alias SetupGetInfInformationW SetupGetInfInformation;
    alias SetupGetLineByIndexW SetupGetLineByIndex;
    alias SetupGetLineCountW SetupGetLineCount;
    alias SetupGetLineTextW SetupGetLineText;
    alias SetupGetMultiSzFieldW SetupGetMultiSzField;
    alias SetupGetSourceFileLocationW SetupGetSourceFileLocation;
    alias SetupGetSourceFileSizeW SetupGetSourceFileSize;
    alias SetupGetSourceInfoW SetupGetSourceInfo;
    alias SetupGetStringFieldW SetupGetStringField;
    alias SetupGetTargetPathW SetupGetTargetPath;
    alias SetupInitializeFileLogW SetupInitializeFileLog;
    alias SetupInstallFileExW SetupInstallFileEx;
    alias SetupInstallFilesFromInfSectionW SetupInstallFilesFromInfSection;
    alias SetupInstallFileW SetupInstallFile;
    alias SetupInstallFromInfSectionW SetupInstallFromInfSection;
    alias SetupInstallServicesFromInfSectionExW SetupInstallServicesFromInfSectionEx;
    alias SetupInstallServicesFromInfSectionW SetupInstallServicesFromInfSection;
    alias SetupIterateCabinetW SetupIterateCabinet;
    alias SetupLogErrorW SetupLogError;
    alias SetupLogFileW SetupLogFile;
    alias SetupOpenAppendInfFileW SetupOpenAppendInfFile;
    alias SetupOpenInfFileW SetupOpenInfFile;
    alias SetupPromptForDiskW SetupPromptForDisk;
    alias SetupQueryDrivesInDiskSpaceListW SetupQueryDrivesInDiskSpaceList;
    alias SetupQueryFileLogW SetupQueryFileLog;
    alias SetupQueryInfFileInformationW SetupQueryInfFileInformation;
    alias SetupQueryInfOriginalFileInformationW SetupQueryInfOriginalFileInformation;
    alias SetupQueryInfVersionInformationW SetupQueryInfVersionInformation;
    alias SetupQuerySourceListW SetupQuerySourceList;
    alias SetupQuerySpaceRequiredOnDriveW SetupQuerySpaceRequiredOnDrive;
    alias SetupQueueCopyIndirectW SetupQueueCopyIndirect;
    alias SetupQueueCopySectionW SetupQueueCopySection;
    alias SetupQueueCopyW SetupQueueCopy;
    alias SetupQueueDefaultCopyW SetupQueueDefaultCopy;
    alias SetupQueueDeleteSectionW SetupQueueDeleteSection;
    alias SetupQueueDeleteW SetupQueueDelete;
    alias SetupQueueRenameSectionW SetupQueueRenameSection;
    alias SetupQueueRenameW SetupQueueRename;
    alias SetupRemoveFileLogEntryW SetupRemoveFileLogEntry;
    alias SetupRemoveFromDiskSpaceListW SetupRemoveFromDiskSpaceList;
    alias SetupRemoveFromSourceListW SetupRemoveFromSourceList;
    alias SetupRemoveInstallSectionFromDiskSpaceListW SetupRemoveInstallSectionFromDiskSpaceList;
    alias SetupRemoveSectionFromDiskSpaceListW SetupRemoveSectionFromDiskSpaceList;
    alias SetupRenameErrorW SetupRenameError;
    alias SetupScanFileQueueW SetupScanFileQueue;
    alias SetupSetDirectoryIdExW SetupSetDirectoryIdEx;
    alias SetupSetDirectoryIdW SetupSetDirectoryId;
    alias SetupSetFileQueueAlternatePlatformW SetupSetFileQueueAlternatePlatform;
    alias SetupSetPlatformPathOverrideW SetupSetPlatformPathOverride;
    alias SetupSetSourceListW SetupSetSourceList;
} else {
    alias PSP_FILE_CALLBACK_A PSP_FILE_CALLBACK;
    alias SetupAddInstallSectionToDiskSpaceListA SetupAddInstallSectionToDiskSpaceList;
    alias SetupAddSectionToDiskSpaceListA SetupAddSectionToDiskSpaceList;
    alias SetupAddToDiskSpaceListA SetupAddToDiskSpaceList;
    alias SetupAddToSourceListA SetupAddToSourceList;
    alias SetupAdjustDiskSpaceListA SetupAdjustDiskSpaceList;
    alias SetupBackupErrorA SetupBackupError;
    alias SetupCommitFileQueueA SetupCommitFileQueue;
    alias SetupCopyErrorA SetupCopyError;
    alias SetupCopyOEMInfA SetupCopyOEMInf;
    alias SetupCreateDiskSpaceListA SetupCreateDiskSpaceList;
    alias SetupDecompressOrCopyFileA SetupDecompressOrCopyFile;
    alias SetupDefaultQueueCallbackA SetupDefaultQueueCallback;
    alias SetupDeleteErrorA SetupDeleteError;
    alias SetupDiBuildClassInfoListExA SetupDiBuildClassInfoListEx;
    alias SetupDiClassGuidsFromNameA SetupDiClassGuidsFromName;
    alias SetupDiClassGuidsFromNameExA SetupDiClassGuidsFromNameEx;
    alias SetupDiClassNameFromGuidA SetupDiClassNameFromGuid;
    alias SetupDiClassNameFromGuidExA SetupDiClassNameFromGuidEx;
    alias SetupDiCreateDeviceInfoA SetupDiCreateDeviceInfo;
    alias SetupDiCreateDeviceInfoListExA SetupDiCreateDeviceInfoListEx;
    alias SetupDiCreateDeviceInterfaceA SetupDiCreateDeviceInterface;
    deprecated alias SetupDiCreateDeviceInterfaceA SetupDiCreateInterfaceDevice;
    alias SetupDiCreateDeviceInterfaceRegKeyA SetupDiCreateDeviceInterfaceRegKey;
    deprecated alias SetupDiCreateDeviceInterfaceRegKeyA SetupDiCreateInterfaceDeviceRegKey;
    alias SetupDiCreateDevRegKeyA SetupDiCreateDevRegKey;
    alias SetupDiDeleteDeviceInterfaceData SetupDiDeleteInterfaceDeviceData;
    alias SetupDiEnumDriverInfoA SetupDiEnumDriverInfo;
    alias SetupDiGetActualSectionToInstallA SetupDiGetActualSectionToInstall;
    alias SetupDiGetClassDescriptionA SetupDiGetClassDescription;
    alias SetupDiGetClassDescriptionExA SetupDiGetClassDescriptionEx;
    alias SetupDiGetClassDevPropertySheetsA SetupDiGetClassDevPropertySheets;
    alias SetupDiGetClassDevsA SetupDiGetClassDevs;
    alias SetupDiGetClassDevsExA SetupDiGetClassDevsEx;
    alias SetupDiGetClassImageListExA SetupDiGetClassImageListEx;
    alias SetupDiGetClassInstallParamsA SetupDiGetClassInstallParams;
    alias SetupDiGetClassRegistryPropertyA SetupDiGetClassRegistryProperty;
    alias SetupDiGetDeviceInfoListDetailA SetupDiGetDeviceInfoListDetail;
    alias SetupDiGetDeviceInstallParamsA SetupDiGetDeviceInstallParams;
    alias SetupDiGetDeviceInstanceIdA SetupDiGetDeviceInstanceId;
    alias SetupDiGetDeviceInterfaceDetailA SetupDiGetDeviceInterfaceDetail;
    deprecated alias SetupDiGetDeviceInterfaceDetailA SetupDiGetInterfaceDeviceDetail;
    alias SetupDiGetDeviceRegistryPropertyA SetupDiGetDeviceRegistryProperty;
    alias SetupDiGetDriverInfoDetailA SetupDiGetDriverInfoDetail;
    alias SetupDiGetDriverInstallParamsA SetupDiGetDriverInstallParams;
    alias SetupDiGetHwProfileFriendlyNameA SetupDiGetHwProfileFriendlyName;
    alias SetupDiGetHwProfileFriendlyNameExA SetupDiGetHwProfileFriendlyNameEx;
    alias SetupDiGetHwProfileListExA SetupDiGetHwProfileListEx;
    alias SetupDiGetINFClassA SetupDiGetINFClass;
    alias SetupDiGetSelectedDriverA SetupDiGetSelectedDriver;
    alias SetupDiInstallClassA SetupDiInstallClass;
    alias SetupDiInstallClassExA SetupDiInstallClassEx;
    alias SetupDiOpenClassRegKeyExA SetupDiOpenClassRegKeyEx;
    alias SetupDiOpenDeviceInfoA SetupDiOpenDeviceInfo;
    alias SetupDiOpenDeviceInterfaceA SetupDiOpenDeviceInterface;
    deprecated alias SetupDiOpenDeviceInterfaceA SetupDiOpenInterfaceDevice;
    alias SetupDiSetClassInstallParamsA SetupDiSetClassInstallParams;
    alias SetupDiSetClassRegistryPropertyA SetupDiSetClassRegistryProperty;
    alias SetupDiSetDeviceInstallParamsA SetupDiSetDeviceInstallParams;
    alias SetupDiSetDeviceRegistryPropertyA SetupDiSetDeviceRegistryProperty;
    alias SetupDiSetDriverInstallParamsA SetupDiSetDriverInstallParams;
    alias SetupDiSetSelectedDriverA SetupDiSetSelectedDriver;
    alias SetupDuplicateDiskSpaceListA SetupDuplicateDiskSpaceList;
    alias SetupFindFirstLineA SetupFindFirstLine;
    alias SetupFindNextMatchLineA SetupFindNextMatchLine;
    alias SetupFreeSourceListA SetupFreeSourceList;
    alias SetupGetBackupInformationA SetupGetBackupInformation;
    alias SetupGetFileCompressionInfoA SetupGetFileCompressionInfo;
    alias SetupGetInfFileListA SetupGetInfFileList;
    alias SetupGetInfInformationA SetupGetInfInformation;
    alias SetupGetLineByIndexA SetupGetLineByIndex;
    alias SetupGetLineCountA SetupGetLineCount;
    alias SetupGetLineTextA SetupGetLineText;
    alias SetupGetMultiSzFieldA SetupGetMultiSzField;
    alias SetupGetSourceFileLocationA SetupGetSourceFileLocation;
    alias SetupGetSourceFileSizeA SetupGetSourceFileSize;
    alias SetupGetSourceInfoA SetupGetSourceInfo;
    alias SetupGetStringFieldA SetupGetStringField;
    alias SetupGetTargetPathA SetupGetTargetPath;
    alias SetupInitializeFileLogA SetupInitializeFileLog;
    alias SetupInstallFileA SetupInstallFile;
    alias SetupInstallFileExA SetupInstallFileEx;
    alias SetupInstallFilesFromInfSectionA SetupInstallFilesFromInfSection;
    alias SetupInstallFromInfSectionA SetupInstallFromInfSection;
    alias SetupInstallServicesFromInfSectionA SetupInstallServicesFromInfSection;
    alias SetupInstallServicesFromInfSectionExA SetupInstallServicesFromInfSectionEx;
    alias SetupIterateCabinetA SetupIterateCabinet;
    alias SetupLogErrorA SetupLogError;
    alias SetupLogFileA SetupLogFile;
    alias SetupOpenAppendInfFileA SetupOpenAppendInfFile;
    alias SetupOpenInfFileA SetupOpenInfFile;
    alias SetupPromptForDiskA SetupPromptForDisk;
    alias SetupQueryDrivesInDiskSpaceListA SetupQueryDrivesInDiskSpaceList;
    alias SetupQueryFileLogA SetupQueryFileLog;
    alias SetupQueryInfFileInformationA SetupQueryInfFileInformation;
    alias SetupQueryInfOriginalFileInformationA SetupQueryInfOriginalFileInformation;
    alias SetupQueryInfVersionInformationA SetupQueryInfVersionInformation;
    alias SetupQuerySourceListA SetupQuerySourceList;
    alias SetupQuerySpaceRequiredOnDriveA SetupQuerySpaceRequiredOnDrive;
    alias SetupQueueCopyA SetupQueueCopy;
    alias SetupQueueCopyIndirectA SetupQueueCopyIndirect;
    alias SetupQueueCopySectionA SetupQueueCopySection;
    alias SetupQueueDefaultCopyA SetupQueueDefaultCopy;
    alias SetupQueueDeleteA SetupQueueDelete;
    alias SetupQueueDeleteSectionA SetupQueueDeleteSection;
    alias SetupQueueRenameA SetupQueueRename;
    alias SetupQueueRenameSectionA SetupQueueRenameSection;
    alias SetupRemoveFileLogEntryA SetupRemoveFileLogEntry;
    alias SetupRemoveFromDiskSpaceListA SetupRemoveFromDiskSpaceList;
    alias SetupRemoveFromSourceListA SetupRemoveFromSourceList;
    alias SetupRemoveInstallSectionFromDiskSpaceListA SetupRemoveInstallSectionFromDiskSpaceList;
    alias SetupRemoveSectionFromDiskSpaceListA SetupRemoveSectionFromDiskSpaceList;
    alias SetupRenameErrorA SetupRenameError;
    alias SetupScanFileQueueA SetupScanFileQueue;
    alias SetupSetDirectoryIdA SetupSetDirectoryId;
    alias SetupSetDirectoryIdExA SetupSetDirectoryIdEx;
    alias SetupSetFileQueueAlternatePlatformA SetupSetFileQueueAlternatePlatform;
    alias SetupSetPlatformPathOverrideA SetupSetPlatformPathOverride;
    alias SetupSetSourceListA SetupSetSourceList;
}
