/* Generated by wayland-scanner 1.24.0 */

#ifndef CONTENT_TYPE_V1_SERVER_PROTOCOL_H
#define CONTENT_TYPE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_content_type_v1 The content_type_v1 protocol
 * @section page_ifaces_content_type_v1 Interfaces
 * - @subpage page_iface_wp_content_type_manager_v1 - surface content type manager
 * - @subpage page_iface_wp_content_type_v1 - content type object for a surface
 * @section page_copyright_content_type_v1 Copyright
 * <pre>
 *
 * Copyright © 2021 Emmanuel Gil Peyrot
 * Copyright © 2022 Xaver Hugl
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct wp_content_type_manager_v1;
struct wp_content_type_v1;

#ifndef WP_CONTENT_TYPE_MANAGER_V1_INTERFACE
#define WP_CONTENT_TYPE_MANAGER_V1_INTERFACE
/**
 * @page page_iface_wp_content_type_manager_v1 wp_content_type_manager_v1
 * @section page_iface_wp_content_type_manager_v1_desc Description
 *
 * This interface allows a client to describe the kind of content a surface
 * will display, to allow the compositor to optimize its behavior for it.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_wp_content_type_manager_v1_api API
 * See @ref iface_wp_content_type_manager_v1.
 */
/**
 * @defgroup iface_wp_content_type_manager_v1 The wp_content_type_manager_v1 interface
 *
 * This interface allows a client to describe the kind of content a surface
 * will display, to allow the compositor to optimize its behavior for it.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface wp_content_type_manager_v1_interface;
#endif
#ifndef WP_CONTENT_TYPE_V1_INTERFACE
#define WP_CONTENT_TYPE_V1_INTERFACE
/**
 * @page page_iface_wp_content_type_v1 wp_content_type_v1
 * @section page_iface_wp_content_type_v1_desc Description
 *
 * The content type object allows the compositor to optimize for the kind
 * of content shown on the surface. A compositor may for example use it to
 * set relevant drm properties like "content type".
 *
 * The client may request to switch to another content type at any time.
 * When the associated surface gets destroyed, this object becomes inert and
 * the client should destroy it.
 * @section page_iface_wp_content_type_v1_api API
 * See @ref iface_wp_content_type_v1.
 */
/**
 * @defgroup iface_wp_content_type_v1 The wp_content_type_v1 interface
 *
 * The content type object allows the compositor to optimize for the kind
 * of content shown on the surface. A compositor may for example use it to
 * set relevant drm properties like "content type".
 *
 * The client may request to switch to another content type at any time.
 * When the associated surface gets destroyed, this object becomes inert and
 * the client should destroy it.
 */
extern const struct wl_interface wp_content_type_v1_interface;
#endif

#ifndef WP_CONTENT_TYPE_MANAGER_V1_ERROR_ENUM
#define WP_CONTENT_TYPE_MANAGER_V1_ERROR_ENUM
enum wp_content_type_manager_v1_error {
	/**
	 * wl_surface already has a content type object
	 */
	WP_CONTENT_TYPE_MANAGER_V1_ERROR_ALREADY_CONSTRUCTED = 0,
};
#endif /* WP_CONTENT_TYPE_MANAGER_V1_ERROR_ENUM */

#ifndef WP_CONTENT_TYPE_MANAGER_V1_ERROR_ENUM_IS_VALID
#define WP_CONTENT_TYPE_MANAGER_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_wp_content_type_manager_v1
 * Validate a wp_content_type_manager_v1 error value.
 *
 * @return true on success, false on error.
 * @ref wp_content_type_manager_v1_error
 */
static inline bool
wp_content_type_manager_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_CONTENT_TYPE_MANAGER_V1_ERROR_ALREADY_CONSTRUCTED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_CONTENT_TYPE_MANAGER_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_wp_content_type_manager_v1
 * @struct wp_content_type_manager_v1_interface
 */
struct wp_content_type_manager_v1_interface {
	/**
	 * destroy the content type manager object
	 *
	 * Destroy the content type manager. This doesn't destroy objects
	 * created with the manager.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create a new content type object
	 *
	 * Create a new content type object associated with the given
	 * surface.
	 *
	 * Creating a wp_content_type_v1 from a wl_surface which already
	 * has one attached is a client error: already_constructed.
	 */
	void (*get_surface_content_type)(struct wl_client *client,
					 struct wl_resource *resource,
					 uint32_t id,
					 struct wl_resource *surface);
};


/**
 * @ingroup iface_wp_content_type_manager_v1
 */
#define WP_CONTENT_TYPE_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_content_type_manager_v1
 */
#define WP_CONTENT_TYPE_MANAGER_V1_GET_SURFACE_CONTENT_TYPE_SINCE_VERSION 1

#ifndef WP_CONTENT_TYPE_V1_TYPE_ENUM
#define WP_CONTENT_TYPE_V1_TYPE_ENUM
/**
 * @ingroup iface_wp_content_type_v1
 * possible content types
 *
 * These values describe the available content types for a surface.
 */
enum wp_content_type_v1_type {
	/**
	 * no content type applies
	 *
	 * The content type none means that either the application has no
	 * data about the content type, or that the content doesn't fit
	 * into one of the other categories.
	 */
	WP_CONTENT_TYPE_V1_TYPE_NONE = 0,
	/**
	 * photo content type
	 *
	 * The content type photo describes content derived from digital
	 * still pictures and may be presented with minimal processing.
	 */
	WP_CONTENT_TYPE_V1_TYPE_PHOTO = 1,
	/**
	 * video content type
	 *
	 * The content type video describes a video or animation and may
	 * be presented with more accurate timing to avoid stutter. Where
	 * scaling is needed, scaling methods more appropriate for video
	 * may be used.
	 */
	WP_CONTENT_TYPE_V1_TYPE_VIDEO = 2,
	/**
	 * game content type
	 *
	 * The content type game describes a running game. Its content
	 * may be presented with reduced latency.
	 */
	WP_CONTENT_TYPE_V1_TYPE_GAME = 3,
};
#endif /* WP_CONTENT_TYPE_V1_TYPE_ENUM */

#ifndef WP_CONTENT_TYPE_V1_TYPE_ENUM_IS_VALID
#define WP_CONTENT_TYPE_V1_TYPE_ENUM_IS_VALID
/**
 * @ingroup iface_wp_content_type_v1
 * Validate a wp_content_type_v1 type value.
 *
 * @return true on success, false on error.
 * @ref wp_content_type_v1_type
 */
static inline bool
wp_content_type_v1_type_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_CONTENT_TYPE_V1_TYPE_NONE:
		return version >= 1;
	case WP_CONTENT_TYPE_V1_TYPE_PHOTO:
		return version >= 1;
	case WP_CONTENT_TYPE_V1_TYPE_VIDEO:
		return version >= 1;
	case WP_CONTENT_TYPE_V1_TYPE_GAME:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_CONTENT_TYPE_V1_TYPE_ENUM_IS_VALID */

/**
 * @ingroup iface_wp_content_type_v1
 * @struct wp_content_type_v1_interface
 */
struct wp_content_type_v1_interface {
	/**
	 * destroy the content type object
	 *
	 * Switch back to not specifying the content type of this
	 * surface. This is equivalent to setting the content type to none,
	 * including double buffering semantics. See set_content_type for
	 * details.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * specify the content type
	 *
	 * Set the surface content type. This informs the compositor that
	 * the client believes it is displaying buffers matching this
	 * content type.
	 *
	 * This is purely a hint for the compositor, which can be used to
	 * adjust its behavior or hardware settings to fit the presented
	 * content best.
	 *
	 * The content type is double-buffered state, see wl_surface.commit
	 * for details.
	 * @param content_type the content type
	 */
	void (*set_content_type)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t content_type);
};


/**
 * @ingroup iface_wp_content_type_v1
 */
#define WP_CONTENT_TYPE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_content_type_v1
 */
#define WP_CONTENT_TYPE_V1_SET_CONTENT_TYPE_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
