# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

package Amanda::Feature;
use base qw(Exporter);
use base qw(DynaLoader);
package Amanda::Featurec;
bootstrap Amanda::Feature;
package Amanda::Feature;
@EXPORT = qw();

# ---------- BASE METHODS -------------

package Amanda::Feature;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Amanda::Feature;

*am_string_to_feature = *Amanda::Featurec::am_string_to_feature;
*am_set_default_feature_set = *Amanda::Featurec::am_set_default_feature_set;
*am_init_feature_set = *Amanda::Featurec::am_init_feature_set;
*am_features = *Amanda::Featurec::am_features;

############# Class : Amanda::Feature::Set ##############

package Amanda::Feature::Set;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Amanda::Feature );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Amanda::Featurec::delete_Set($self);
        delete $OWNER{$self};
    }
}

*add = *Amanda::Featurec::Set_add;
*remove = *Amanda::Featurec::Set_remove;
*has = *Amanda::Featurec::Set_has;
*as_string = *Amanda::Featurec::Set_as_string;
sub new {
    my $pkg = shift;
    my $self = Amanda::Featurec::new_Set(@_);
    bless $self, $pkg if defined($self);
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


# ------- VARIABLE STUBS --------

package Amanda::Feature;

*have_feature_support = *Amanda::Featurec::have_feature_support;
*fe_options_auth = *Amanda::Featurec::fe_options_auth;
*fe_selfcheck_req = *Amanda::Featurec::fe_selfcheck_req;
*fe_selfcheck_req_device = *Amanda::Featurec::fe_selfcheck_req_device;
*fe_selfcheck_rep = *Amanda::Featurec::fe_selfcheck_rep;
*fe_sendsize_req_no_options = *Amanda::Featurec::fe_sendsize_req_no_options;
*fe_sendsize_req_options = *Amanda::Featurec::fe_sendsize_req_options;
*fe_sendsize_req_device = *Amanda::Featurec::fe_sendsize_req_device;
*fe_sendsize_rep = *Amanda::Featurec::fe_sendsize_rep;
*fe_sendbackup_req = *Amanda::Featurec::fe_sendbackup_req;
*fe_sendbackup_req_device = *Amanda::Featurec::fe_sendbackup_req_device;
*fe_sendbackup_rep = *Amanda::Featurec::fe_sendbackup_rep;
*fe_noop_req = *Amanda::Featurec::fe_noop_req;
*fe_noop_rep = *Amanda::Featurec::fe_noop_rep;
*fe_program_dump = *Amanda::Featurec::fe_program_dump;
*fe_program_gnutar = *Amanda::Featurec::fe_program_gnutar;
*fe_program_application_api = *Amanda::Featurec::fe_program_application_api;
*fe_options_compress_fast = *Amanda::Featurec::fe_options_compress_fast;
*fe_options_compress_best = *Amanda::Featurec::fe_options_compress_best;
*fe_options_srvcomp_fast = *Amanda::Featurec::fe_options_srvcomp_fast;
*fe_options_srvcomp_best = *Amanda::Featurec::fe_options_srvcomp_best;
*fe_options_no_record = *Amanda::Featurec::fe_options_no_record;
*fe_options_index = *Amanda::Featurec::fe_options_index;
*fe_options_exclude_file = *Amanda::Featurec::fe_options_exclude_file;
*fe_options_exclude_list = *Amanda::Featurec::fe_options_exclude_list;
*fe_options_multiple_exclude = *Amanda::Featurec::fe_options_multiple_exclude;
*fe_options_optional_exclude = *Amanda::Featurec::fe_options_optional_exclude;
*fe_options_include_file = *Amanda::Featurec::fe_options_include_file;
*fe_options_include_list = *Amanda::Featurec::fe_options_include_list;
*fe_options_multiple_include = *Amanda::Featurec::fe_options_multiple_include;
*fe_options_optional_include = *Amanda::Featurec::fe_options_optional_include;
*fe_options_bsd_auth = *Amanda::Featurec::fe_options_bsd_auth;
*fe_options_krb4_auth = *Amanda::Featurec::fe_options_krb4_auth;
*fe_options_kencrypt = *Amanda::Featurec::fe_options_kencrypt;
*fe_req_options_maxdumps = *Amanda::Featurec::fe_req_options_maxdumps;
*fe_req_options_hostname = *Amanda::Featurec::fe_req_options_hostname;
*fe_req_options_features = *Amanda::Featurec::fe_req_options_features;
*fe_rep_options_maxdumps = *Amanda::Featurec::fe_rep_options_maxdumps;
*fe_rep_options_hostname = *Amanda::Featurec::fe_rep_options_hostname;
*fe_rep_options_features = *Amanda::Featurec::fe_rep_options_features;
*fe_rep_options_sendbackup_options = *Amanda::Featurec::fe_rep_options_sendbackup_options;
*fe_amindexd_fileno_in_OLSD = *Amanda::Featurec::fe_amindexd_fileno_in_OLSD;
*fe_amindexd_fileno_in_ORLD = *Amanda::Featurec::fe_amindexd_fileno_in_ORLD;
*fe_amidxtaped_fsf = *Amanda::Featurec::fe_amidxtaped_fsf;
*fe_amidxtaped_label = *Amanda::Featurec::fe_amidxtaped_label;
*fe_amidxtaped_device = *Amanda::Featurec::fe_amidxtaped_device;
*fe_amidxtaped_host = *Amanda::Featurec::fe_amidxtaped_host;
*fe_amidxtaped_disk = *Amanda::Featurec::fe_amidxtaped_disk;
*fe_amidxtaped_datestamp = *Amanda::Featurec::fe_amidxtaped_datestamp;
*fe_amidxtaped_header = *Amanda::Featurec::fe_amidxtaped_header;
*fe_amidxtaped_nargs = *Amanda::Featurec::fe_amidxtaped_nargs;
*fe_amidxtaped_config = *Amanda::Featurec::fe_amidxtaped_config;
*fe_partial_estimate = *Amanda::Featurec::fe_partial_estimate;
*fe_calcsize_estimate = *Amanda::Featurec::fe_calcsize_estimate;
*fe_selfcheck_calcsize = *Amanda::Featurec::fe_selfcheck_calcsize;
*fe_recover_splits = *Amanda::Featurec::fe_recover_splits;
*fe_amidxtaped_exchange_features = *Amanda::Featurec::fe_amidxtaped_exchange_features;
*fe_options_compress_cust = *Amanda::Featurec::fe_options_compress_cust;
*fe_options_srvcomp_cust = *Amanda::Featurec::fe_options_srvcomp_cust;
*fe_options_encrypt_cust = *Amanda::Featurec::fe_options_encrypt_cust;
*fe_options_encrypt_serv_cust = *Amanda::Featurec::fe_options_encrypt_serv_cust;
*fe_options_client_decrypt_option = *Amanda::Featurec::fe_options_client_decrypt_option;
*fe_options_server_decrypt_option = *Amanda::Featurec::fe_options_server_decrypt_option;
*fe_amindexd_marshall_in_OLSD = *Amanda::Featurec::fe_amindexd_marshall_in_OLSD;
*fe_amindexd_marshall_in_ORLD = *Amanda::Featurec::fe_amindexd_marshall_in_ORLD;
*fe_amindexd_marshall_in_DHST = *Amanda::Featurec::fe_amindexd_marshall_in_DHST;
*fe_amrecover_FEEDME = *Amanda::Featurec::fe_amrecover_FEEDME;
*fe_amrecover_timestamp = *Amanda::Featurec::fe_amrecover_timestamp;
*fe_interface_quoted_text = *Amanda::Featurec::fe_interface_quoted_text;
*fe_program_star = *Amanda::Featurec::fe_program_star;
*fe_amindexd_options_hostname = *Amanda::Featurec::fe_amindexd_options_hostname;
*fe_amindexd_options_features = *Amanda::Featurec::fe_amindexd_options_features;
*fe_amindexd_options_auth = *Amanda::Featurec::fe_amindexd_options_auth;
*fe_amidxtaped_options_hostname = *Amanda::Featurec::fe_amidxtaped_options_hostname;
*fe_amidxtaped_options_features = *Amanda::Featurec::fe_amidxtaped_options_features;
*fe_amidxtaped_options_auth = *Amanda::Featurec::fe_amidxtaped_options_auth;
*fe_amrecover_message = *Amanda::Featurec::fe_amrecover_message;
*fe_amrecover_feedme_tape = *Amanda::Featurec::fe_amrecover_feedme_tape;
*fe_req_options_config = *Amanda::Featurec::fe_req_options_config;
*fe_rep_sendsize_quoted_error = *Amanda::Featurec::fe_rep_sendsize_quoted_error;
*fe_req_xml = *Amanda::Featurec::fe_req_xml;
*fe_pp_script = *Amanda::Featurec::fe_pp_script;
*fe_amindexd_DLE = *Amanda::Featurec::fe_amindexd_DLE;
*fe_amrecover_dle_in_header = *Amanda::Featurec::fe_amrecover_dle_in_header;
*fe_xml_estimate = *Amanda::Featurec::fe_xml_estimate;
*fe_xml_property_priority = *Amanda::Featurec::fe_xml_property_priority;
*fe_sendsize_rep_warning = *Amanda::Featurec::fe_sendsize_rep_warning;
*fe_xml_estimatelist = *Amanda::Featurec::fe_xml_estimatelist;
*fe_xml_level_server = *Amanda::Featurec::fe_xml_level_server;
*fe_xml_data_path = *Amanda::Featurec::fe_xml_data_path;
*fe_xml_directtcp_list = *Amanda::Featurec::fe_xml_directtcp_list;
*fe_amidxtaped_datapath = *Amanda::Featurec::fe_amidxtaped_datapath;
*fe_sendbackup_noop = *Amanda::Featurec::fe_sendbackup_noop;
*fe_amrecover_origsize_in_header = *Amanda::Featurec::fe_amrecover_origsize_in_header;
*fe_amidxtaped_abort = *Amanda::Featurec::fe_amidxtaped_abort;
*fe_amrecover_correct_disk_quoting = *Amanda::Featurec::fe_amrecover_correct_disk_quoting;
*fe_amindexd_quote_label = *Amanda::Featurec::fe_amindexd_quote_label;
*fe_amrecover_receive_unfiltered = *Amanda::Featurec::fe_amrecover_receive_unfiltered;
*fe_application_client_name = *Amanda::Featurec::fe_application_client_name;
*fe_script_client_name = *Amanda::Featurec::fe_script_client_name;
*fe_dumptype_property = *Amanda::Featurec::fe_dumptype_property;
*fe_sendbackup_state = *Amanda::Featurec::fe_sendbackup_state;
*fe_sendbackup_crc = *Amanda::Featurec::fe_sendbackup_crc;
*fe_amrecover_crc_in_header = *Amanda::Featurec::fe_amrecover_crc_in_header;
*fe_amrecover_data_status = *Amanda::Featurec::fe_amrecover_data_status;
*fe_amrecover_data_crc = *Amanda::Featurec::fe_amrecover_data_crc;
*fe_amrecover_storage_in_marshall = *Amanda::Featurec::fe_amrecover_storage_in_marshall;
*fe_amidxtaped_storage_in_marshall = *Amanda::Featurec::fe_amidxtaped_storage_in_marshall;
*fe_amindexd_STORAGE = *Amanda::Featurec::fe_amindexd_STORAGE;
*fe_sendbackup_retry = *Amanda::Featurec::fe_sendbackup_retry;
*fe_sendbackup_retry_delay = *Amanda::Featurec::fe_sendbackup_retry_delay;
*fe_sendbackup_retry_level = *Amanda::Featurec::fe_sendbackup_retry_level;
*fe_sendbackup_retry_message = *Amanda::Featurec::fe_sendbackup_retry_message;
*fe_selfcheck_message = *Amanda::Featurec::fe_selfcheck_message;
*fe_sendsize_message = *Amanda::Featurec::fe_sendsize_message;
*fe_sendbackup_message = *Amanda::Featurec::fe_sendbackup_message;
*fe_sendbackup_rep_retry = *Amanda::Featurec::fe_sendbackup_rep_retry;
*fe_sendbackup_stream_state = *Amanda::Featurec::fe_sendbackup_stream_state;
*fe_amrecover_stream_state = *Amanda::Featurec::fe_amrecover_stream_state;
*fe_amidxtaped_dar = *Amanda::Featurec::fe_amidxtaped_dar;
*fe_restore_mesg_json = *Amanda::Featurec::fe_restore_mesg_json;
*fe_restore_state_stream = *Amanda::Featurec::fe_restore_state_stream;
*fe_amrecover_header_send_size = *Amanda::Featurec::fe_amrecover_header_send_size;
*fe_amrecover_header_ready = *Amanda::Featurec::fe_amrecover_header_ready;
*fe_amrecover_header_done = *Amanda::Featurec::fe_amrecover_header_done;
*fe_amrecover_state_send = *Amanda::Featurec::fe_amrecover_state_send;
*fe_amrecover_state_ready = *Amanda::Featurec::fe_amrecover_state_ready;
*fe_amrecover_state_done = *Amanda::Featurec::fe_amrecover_state_done;
*fe_amrecover_data_send = *Amanda::Featurec::fe_amrecover_data_send;
*fe_amrecover_data_ready = *Amanda::Featurec::fe_amrecover_data_ready;
*fe_amrecover_data_done = *Amanda::Featurec::fe_amrecover_data_done;
*fe_restore_header_send_size = *Amanda::Featurec::fe_restore_header_send_size;
*fe_restore_header_ready = *Amanda::Featurec::fe_restore_header_ready;
*fe_restore_header_done = *Amanda::Featurec::fe_restore_header_done;
*fe_restore_state_send = *Amanda::Featurec::fe_restore_state_send;
*fe_restore_state_ready = *Amanda::Featurec::fe_restore_state_ready;
*fe_restore_state_done = *Amanda::Featurec::fe_restore_state_done;
*fe_restore_data_send = *Amanda::Featurec::fe_restore_data_send;
*fe_restore_data_ready = *Amanda::Featurec::fe_restore_data_ready;
*fe_restore_data_done = *Amanda::Featurec::fe_restore_data_done;
*fe_restore_dar = *Amanda::Featurec::fe_restore_dar;
*fe_restore_datapath = *Amanda::Featurec::fe_restore_datapath;
*fe_restore_include = *Amanda::Featurec::fe_restore_include;
*fe_restore_include_glob = *Amanda::Featurec::fe_restore_include_glob;
*fe_restore_exclude = *Amanda::Featurec::fe_restore_exclude;
*fe_restore_exclude_glob = *Amanda::Featurec::fe_restore_exclude_glob;
*fe_restore_prev_next_level = *Amanda::Featurec::fe_restore_prev_next_level;
*fe_sendbackup_req_options_data_shm_control_name = *Amanda::Featurec::fe_sendbackup_req_options_data_shm_control_name;
*fe_req_options_timestamp = *Amanda::Featurec::fe_req_options_timestamp;
*fe_sendbackup_stream_cmd = *Amanda::Featurec::fe_sendbackup_stream_cmd;
*fe_sendbackup_stream_cmd_get_dumper_result = *Amanda::Featurec::fe_sendbackup_stream_cmd_get_dumper_result;
*fe_sendbackup_statedone = *Amanda::Featurec::fe_sendbackup_statedone;
*last_feature = *Amanda::Featurec::last_feature;

@EXPORT_OK = ();
%EXPORT_TAGS = ();


=head1 NAME

Amanda::Feature - interface to Amanda feature bitfields

=head1 SYNOPSIS

    # set up features for this instance and print them
    my $features = Amanda::Feature::Set->mine();
    print "my features: $features\n";

    # parse the other side's features
    my $client_feat = Amanda::Feature::Set->from_string($feat_str);

    # or assume the other side's features are old
    my $client_feat = Amanda::Feature::Set->old()

    # test for a feature
    if ($feat->has($Amanda::Feature::fe_options_bsd_auth)) {
	print "has BSD auth\n";
    }

=head1 DESCRIPTION

C<Amanda::Feature::Set> objects are fairly simple.  The three constructors are
shown in the SYNOPSIS: C<mine> (all currently-supported features), C<old> (only
the features present in versions of Amanda before features were invented), or
C<from_string>.

An object has three methods to address specific bits:

    # set a bit
    $feat->add($Amanda::Feature::fe_req_xml);

    # clear a bit
    $feat->remove($Amanda::Feature::fe_req_xml);

    # test a bit
    if ($feat->has($Amanda::Feature::fe_req_xml)) ..

And C<as_string> which converts the feature into a string.

All features are available in scalars of the same name in the
C<Amanda::Feature> namespace.

=head1 FEATURE DOCUMENTATION

This section includes as much information as is available for each feature.
Each subsection begins with a description of the protocols in
which the feature is relevant, and the end on which the feature is relevant.
Any known dependencies for the feature are also mentioned.  Assume that any
omissions in this section are due to limited information.

=over 2

=item fe_recover_splits

 PROTOCOL: amidxtaped
 FEATURE OF: client

If set, the recovery application supports a DATA connection on a separate TCP
connection.

Dependencies: this feature is always set when amidxtaped is invoked via
amandad.

=item fe_amidxtaped_exchange_features

 PROTOCOL: amidxtaped
 FEATURE OF: server

If set, amidxtaped can process the FEATURES= line in the command.
The flag is actually tested by amrecover on amindexd's feature matrix, due to
ordering constraints, so it assumes that amindexd and amidxtaped have the same
features.

=item fe_amrecover_FEEDME

 PROTOCOL: amidxtaped
 FEATURE OF: client

If set, amrecover understands FEEDME lines on the control connection.

Dependencies: this feature can only be set if fe_recover_splits is set.

=item fe_amrecover_timestamp

 PROTOCOL: amindexd
 FEATURE OF: client

If set, the recovery application supports full timestamps; otherwise, it can
only process datestamps.

=item fe_amidxtaped_options_hostname

=item fe_amidxtaped_options_features

=item fe_amidxtaped_options_auth

 PROTOCOL: amidxtaped
 FEATURE OF: server

These feature flags indicate what fields amidxtaped supports in the OPTIONS
line.  Of course, the client would need to know these features before it
received the OPTIONS line, which would necessitate sending a NOOP request
first.  In practice, they are completely unused.

=item fe_amrecover_message

 PROTOCOL: amidxtaped
 FEATURE OF: client

If set, the recovery applications understands MESSAGE lines on the control connection.

Dependencies: a control connection only exists if amidxtaped is launched from
amandad or I<fe_recover_splits> is used.

=item fe_amrecover_feedme_tape

 PROTOCOL: amidxtaped
 FEATURE OF: server

If set, amidxtaped recognizes the TAPE response to FEEDME.

=item fe_amrecover_dle_in_header

=item fe_amrecover_origsize_in_header

 PROTOCOL: amidxtaped
 FEATURE OF: client

If set, amrecover can process a header containing the corresponding attribute.
If not set, the attribute should be stripped from any headers sent to
amrecover.

 Feature                Header Attribute
 -------                ----------------
 dle_in_header          dle_str
 origsize_in_header     orig_size

=item fe_amidxtaped_abort

 PROTOCOL: amidxtaped
 FEATURE OF: server

If set, amidxtaped can handle an ABORT message just before the datapath
negotiation begins.

=item fe_amidxtaped_datapath

 PROTOCOL: amidxtaped
 FEATURE OF: client and server

If set on the client, then amrecover expects the server to start a DATAPATH
negotiation after the header is sent.  If set on the server, then amrecover can
process a DATAPATH negotiation after the header is sent.  In other words, the
feature must be present on both sides for this negotiation to take place.  The
DATAPATH negotiation is a three-way handshake:

  AVAIL-DATAPATH <datapath list>         # to amidxtaped
  USE-DATAPATH <datapath> [<ip:port> ..] # from amidxtaped
  DATAPATH-OK                            # to amidxtaped

No data may be transmitted until the handshake is complete.  See the wiki
article entitled "amidxtaped protocol" for more detail.

=item fe_amidxtaped_fsf

=item fe_amidxtaped_label

=item fe_amidxtaped_device

=item fe_amidxtaped_host

=item fe_amidxtaped_disk

=item fe_amidxtaped_datestamp

=item fe_amidxtaped_header

=item fe_amidxtaped_config

 PROTOCOL: amidxtaped
 FEATURE OF: server

If set, each feature means that amidxtaped can process the corresponding
command line.  Note that I<fe_amidxtaped_label> does not indicate whether that
field contains a label or a tapespec.

=item fe_amidxtaped_nargs

 PROTOCOL: amidxtaped
 FEATURE OF: server

If set, then amidxtaped can handle the "nargs" form of a command: The first
line was the number of arguments, folloewd by one argument by line.  Amidxtaped
forked amrestore with these arguments.

This feature is no longer supported.

=item fe_amrecover_correct_disk_quoting

 PROTOCOL: amidxtaped
 FEATURE OF: amrecover

Amrecovers that do not have this flag may send incorrectly-quoted DISK lines, so
those DISK lines should be ignored.

=item fe_amindexd_quote_label

 PROTOCOL: amindexd
 FEATURE OF: server

If set, amindexd quote the label (holdingdisk filename)

=item fe_amrecover_receive_unfiltered

 PROTOCOL: amidxtaped
 FEATURE OF: client

If set, amidxtaped do not decompress/decrypt client compressed/decrypted stream.

=item fe_application_client_name

If set, add the 'client_name' for application in the xml code.

=item fe_script_client_name

If set, add the 'client_name' for script in the xml code.

=item fe_dumptype_property

If set, add the dumptype property in the xml code.

=back

=cut



package Amanda::Feature::Set;

# this does not work, because SWIG uses the string value of objects as a hash key
# even after calling their destructor, which leads to a segfault.
#
# use overload '""' => sub { $_[0]->as_string(); };

sub Amanda::Feature::Set::from_string {
    my $class = shift;
    return Amanda::Feature::am_string_to_feature(@_);
}

sub Amanda::Feature::Set::old {
    my $class = shift;
    return Amanda::Feature::am_set_default_feature_set();
}

sub Amanda::Feature::Set::mine {
    my $class = shift;
    return Amanda::Feature::am_init_feature_set();
}

sub Amanda::Feature::Set::features {
    my $class = shift;
    return Amanmda::Feature::features();
}


package Amanda::Feature;

1;
