## RabbitMQ 3.7.28

RabbitMQ `3.7.28` is a security patch release.


RabbitMQ `3.7.x` series are out of general support and covered by the [limited extended support policy](https://www.rabbitmq.com/versions.html)
through October 1st, 2020.
Please consider [upgrading](https://www.rabbitmq.com/upgrade.html) to [RabbitMQ `3.8.x`](https://www.rabbitmq.com/changelog.html).

RabbitMQ Core team would like to thank Ofir Hamam and Tomer Hadad at Ernst & Young's Hacktics Advanced Security Center
for researching and responsibly disclosing the vulnerability addressed in this release.

### Erlang/OTP Compatibility Notes

This release [**no longer supports Erlang/OTP 20.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Erlang `21.3+` is now a **hard requirement** checked on node startup.

Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.
[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Bug Fixes

 * Addressed a Windows-specific binary planting security vulnerability [CVE-2020-5419](https://tanzu.vmware.com/security/cve-2020-5419) that allowed for arbitrary code execution.
   The vulnerability requires the attacker to have local access and elevated privileges,
   and cannot be executed remotely.

   [CVSS score](https://www.first.org/cvss/calculator/3.0#CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:H): `6.7` (medium severity).

   This vulnerability was researched and [responsibly disclosed](https://www.rabbitmq.com/contact.html#security) by
   Ofir Hamam and Tomer Hadad at Ernst & Young's Hacktics Advanced Security Center.



## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.28.tar.xz`.
