/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

class InitialInferenceState {
    private final Set<InferenceVariable> myInferenceVariables;
    private final PsiElement myContext;
    private final PsiSubstitutor myInferenceSubstitutor;
    private final PsiSubstitutor mySiteSubstitutor;
    private final ArrayList<Pair<InferenceVariable[], PsiClassType>> myCaptures;
    private final InferenceSessionContainer myInferenceSessionContainer;
    private final boolean myErased;

    InitialInferenceState(Collection<InferenceVariable> inferenceVariables, PsiSubstitutor topInferenceSubstitutor, PsiElement context, PsiSubstitutor inferenceSubstitutor, PsiSubstitutor siteSubstitutor, List<Pair<InferenceVariable[], PsiClassType>> captures, boolean erased, InferenceSessionContainer inferenceSessionContainer) {
        this.myErased = erased;
        this.myInferenceVariables = new HashSet<InferenceVariable>();
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (InferenceVariable inferenceVariable : inferenceVariables) {
            PsiType substitute2 = topInferenceSubstitutor.substitute(inferenceVariable);
            PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(substitute2);
            if (!(aClass2 instanceof InferenceVariable)) continue;
            this.myInferenceVariables.add((InferenceVariable)aClass2);
            if (!inferenceSubstitutor.getSubstitutionMap().containsValue(PsiSubstitutor.EMPTY.substitute(inferenceVariable))) continue;
            substitutor2 = substitutor2.put(inferenceVariable.getParameter(), substitute2);
            subst = subst.put(inferenceVariable, substitute2);
        }
        this.myInferenceSubstitutor = substitutor2;
        this.myContext = context;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myCaptures = new ArrayList();
        for (Pair pair : captures) {
            InferenceVariable[] newParameters = new InferenceVariable[((InferenceVariable[])pair.first).length];
            InferenceVariable[] parameters2 = (InferenceVariable[])pair.first;
            for (int i = 0; i < parameters2.length; ++i) {
                PsiType substitute3 = topInferenceSubstitutor.substitute(parameters2[i]);
                newParameters[i] = (InferenceVariable)PsiUtil.resolveClassInClassTypeOnly(substitute3);
            }
            this.myCaptures.add(Pair.create(newParameters, (PsiClassType)subst.substitute((PsiType)pair.second)));
        }
        this.myInferenceSessionContainer = inferenceSessionContainer;
    }

    InferenceSessionContainer getInferenceSessionContainer() {
        return this.myInferenceSessionContainer;
    }

    Set<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    PsiSubstitutor getInferenceSubstitutor() {
        return this.myInferenceSubstitutor;
    }

    PsiSubstitutor getSiteSubstitutor() {
        return this.mySiteSubstitutor;
    }

    public ArrayList<Pair<InferenceVariable[], PsiClassType>> getCaptures() {
        return this.myCaptures;
    }

    public boolean isErased() {
        return this.myErased;
    }
}

