/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.concurrent.Callable;
import org.gradle.api.internal.provider.DefaultPropertyState;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.util.DeprecationLogger;

public class DefaultProviderFactory
implements ProviderFactory {
    public <T> Provider<T> provider(Callable<? extends T> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        return new DefaultProvider<T>(value);
    }

    public <T> PropertyState<T> property(Class<T> valueType) {
        DeprecationLogger.nagUserOfReplacedMethod((String)"property(Class)", (String)"ObjectFactory.property(Class)");
        return this.propertyNoNag(valueType);
    }

    public <T> PropertyState<T> propertyNoNag(Class<T> valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        DefaultPropertyState<T> propertyState = new DefaultPropertyState<T>(valueType);
        if (valueType == Boolean.class) {
            propertyState.set(Providers.FALSE);
        } else if (valueType == Byte.class) {
            propertyState.set(Providers.BYTE_ZERO);
        } else if (valueType == Short.class) {
            propertyState.set(Providers.SHORT_ZERO);
        } else if (valueType == Integer.class) {
            propertyState.set(Providers.INTEGER_ZERO);
        } else if (valueType == Long.class) {
            propertyState.set(Providers.LONG_ZERO);
        } else if (valueType == Float.class) {
            propertyState.set(Providers.FLOAT_ZERO);
        } else if (valueType == Double.class) {
            propertyState.set(Providers.DOUBLE_ZERO);
        } else if (valueType == Character.class) {
            propertyState.set(Providers.CHAR_ZERO);
        }
        return propertyState;
    }
}

