/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.TreeWriter;
import java.net.URI;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

public class ProcessMatch
extends TreeWriter {
    public static final int SAW_ELEMENT = 1;
    public static final int SAW_WHITESPACE = 2;
    public static final int SAW_TEXT = 4;
    public static final int SAW_PI = 8;
    public static final int SAW_COMMENT = 16;
    private ProcessMatchingNodes processor = null;
    private int saw = 0;
    private XPathExpression matcher = null;
    private Configuration saxonConfig = null;
    private int count;

    public ProcessMatch(XProcRuntime xProcRuntime, ProcessMatchingNodes processMatchingNodes) {
        super(xProcRuntime);
        this.runtime = xProcRuntime;
        this.processor = processMatchingNodes;
        this.saxonConfig = xProcRuntime.getProcessor().getUnderlyingConfiguration();
    }

    public void match(XdmNode xdmNode, RuntimeValue runtimeValue) {
        XdmNode xdmNode2 = runtimeValue.getNode();
        try {
            XPathEvaluator xPathEvaluator = new XPathEvaluator(this.saxonConfig);
            MatchingNamespaceResolver matchingNamespaceResolver = new MatchingNamespaceResolver(runtimeValue.getNamespaceBindings());
            xPathEvaluator.setNamespaceResolver((NamespaceResolver)matchingNamespaceResolver);
            this.matcher = xPathEvaluator.createPattern(runtimeValue.getString());
            this.destination = new XdmDestination();
            this.receiver = this.destination.getReceiver(this.saxonConfig);
            this.receiver = new NamespaceReducer(this.receiver);
            PipelineConfiguration pipelineConfiguration = this.controller.makePipelineConfiguration();
            pipelineConfiguration.setLocationProvider((LocationProvider)this.xLocationProvider);
            this.receiver.setPipelineConfiguration(pipelineConfiguration);
            this.receiver.setSystemId(xdmNode.getBaseURI().toASCIIString());
            this.receiver.open();
            if (xdmNode.getNodeKind() != XdmNodeKind.DOCUMENT) {
                this.startDocument(xdmNode.getBaseURI());
            }
            this.traverse(xdmNode);
            if (xdmNode.getNodeKind() != XdmNodeKind.DOCUMENT) {
                this.endDocument();
            }
            this.receiver.close();
        }
        catch (XProcException xProcException) {
            throw xProcException;
        }
        catch (Exception exception) {
            if (exception.getMessage() != null && exception.getMessage().contains("syntax error")) {
                throw XProcException.dynamicError(23, xdmNode2, exception, "Syntax error in match pattern: \"" + runtimeValue.getString() + "\"");
            }
            throw XProcException.dynamicError(23, xdmNode2, exception, "Expression could not be evaluated");
        }
    }

    @Override
    public void startDocument(URI uRI) {
        this.inDocument = true;
        this.seenRoot = false;
        try {
            this.receiver.startDocument(0);
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
    }

    public int count(XdmNode xdmNode, RuntimeValue runtimeValue, boolean bl) {
        this.count = 0;
        try {
            XPathEvaluator xPathEvaluator = new XPathEvaluator(this.saxonConfig);
            MatchingNamespaceResolver matchingNamespaceResolver = new MatchingNamespaceResolver(runtimeValue.getNamespaceBindings());
            xPathEvaluator.setNamespaceResolver((NamespaceResolver)matchingNamespaceResolver);
            this.matcher = xPathEvaluator.createPattern(runtimeValue.getString());
            this.traverse(xdmNode, bl);
        }
        catch (XProcException xProcException) {
            throw xProcException;
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
        return this.count;
    }

    @Override
    public XdmNode getResult() {
        return this.destination.getXdmNode();
    }

    public boolean matches(XdmNode xdmNode) {
        try {
            XPathDynamicContext xPathDynamicContext = this.matcher.createDynamicContext((Item)xdmNode.getUnderlyingNode());
            return this.matcher.effectiveBooleanValue(xPathDynamicContext);
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    private void traverse(XdmNode xdmNode) throws SaxonApiException, XPathException {
        boolean bl = this.matches(xdmNode);
        boolean bl2 = false;
        if (!bl) {
            if (xdmNode.getNodeKind() == XdmNodeKind.ELEMENT) {
                this.saw |= 1;
            } else if (xdmNode.getNodeKind() == XdmNodeKind.TEXT) {
                this.saw = "".equals(xdmNode.getStringValue().trim()) ? (this.saw |= 2) : (this.saw |= 4);
            } else if (xdmNode.getNodeKind() == XdmNodeKind.COMMENT) {
                this.saw |= 0x10;
            } else if (xdmNode.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
                this.saw |= 8;
            }
        }
        if (xdmNode.getNodeKind() == XdmNodeKind.DOCUMENT) {
            if (bl) {
                bl2 = this.processor.processStartDocument(xdmNode);
                this.saw = 0;
            } else {
                this.startDocument(xdmNode.getBaseURI());
            }
            if (!bl || bl2) {
                XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
                while (xdmSequenceIterator.hasNext()) {
                    XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                    this.traverse(xdmNode2);
                }
            }
            if (bl) {
                this.processor.processEndDocument(xdmNode);
            } else {
                this.endDocument();
            }
        } else if (xdmNode.getNodeKind() == XdmNodeKind.ELEMENT) {
            XdmNode xdmNode3;
            XdmSequenceIterator xdmSequenceIterator;
            if (bl) {
                bl2 = this.processor.processStartElement(xdmNode);
                this.saw = 0;
            } else {
                this.addStartElement(xdmNode);
            }
            if (!bl) {
                xdmSequenceIterator = xdmNode.axisIterator(Axis.ATTRIBUTE);
                while (xdmSequenceIterator.hasNext()) {
                    xdmNode3 = (XdmNode)xdmSequenceIterator.next();
                    if (this.matches(xdmNode3)) continue;
                    this.traverse(xdmNode3);
                }
                xdmSequenceIterator = xdmNode.axisIterator(Axis.ATTRIBUTE);
                while (xdmSequenceIterator.hasNext()) {
                    xdmNode3 = (XdmNode)xdmSequenceIterator.next();
                    if (!this.matches(xdmNode3)) continue;
                    this.traverse(xdmNode3);
                }
                this.receiver.startContent();
            }
            if (!bl || bl2) {
                xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
                while (xdmSequenceIterator.hasNext()) {
                    xdmNode3 = (XdmNode)xdmSequenceIterator.next();
                    this.traverse(xdmNode3);
                }
            }
            if (bl) {
                this.processor.processEndElement(xdmNode);
            } else {
                this.addEndElement();
            }
        } else if (xdmNode.getNodeKind() == XdmNodeKind.ATTRIBUTE) {
            if (bl) {
                this.processor.processAttribute(xdmNode);
                this.saw = 0;
            } else {
                this.addAttribute(xdmNode.getNodeName(), xdmNode.getStringValue());
            }
        } else if (xdmNode.getNodeKind() == XdmNodeKind.COMMENT) {
            if (bl) {
                this.processor.processComment(xdmNode);
                this.saw = 0;
            } else {
                this.addComment(xdmNode.getStringValue());
            }
        } else if (xdmNode.getNodeKind() == XdmNodeKind.TEXT) {
            if (bl) {
                this.processor.processText(xdmNode);
                this.saw = 0;
            } else {
                this.addText(xdmNode.getStringValue());
            }
        } else if (xdmNode.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
            if (bl) {
                this.processor.processPI(xdmNode);
                this.saw = 0;
            } else {
                this.addPI(xdmNode.getNodeName().getLocalName(), xdmNode.getStringValue());
            }
        } else {
            throw new UnsupportedOperationException("Unexpected node type");
        }
    }

    private void traverse(XdmNode xdmNode, boolean bl) throws SaxonApiException, XPathException {
        block6: {
            boolean bl2;
            block5: {
                bl2 = this.matches(xdmNode);
                if (bl2) {
                    ++this.count;
                }
                if (xdmNode.getNodeKind() != XdmNodeKind.DOCUMENT) break block5;
                if (bl2 && !bl) break block6;
                XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
                while (xdmSequenceIterator.hasNext()) {
                    XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                    this.traverse(xdmNode2, bl);
                }
                break block6;
            }
            if (xdmNode.getNodeKind() == XdmNodeKind.ELEMENT && (!bl2 || bl)) {
                XdmNode xdmNode3;
                XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.ATTRIBUTE);
                while (xdmSequenceIterator.hasNext()) {
                    xdmNode3 = (XdmNode)xdmSequenceIterator.next();
                    this.traverse(xdmNode3, bl);
                }
                xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
                while (xdmSequenceIterator.hasNext()) {
                    xdmNode3 = (XdmNode)xdmSequenceIterator.next();
                    this.traverse(xdmNode3, bl);
                }
            }
        }
    }

    private class MatchingNamespaceResolver
    implements NamespaceResolver {
        private Hashtable<String, String> ns = new Hashtable();

        public MatchingNamespaceResolver(Hashtable<String, String> hashtable) {
            this.ns = hashtable;
        }

        public String getURIForPrefix(String string, boolean bl) {
            if ("".equals(string) && !bl) {
                return "";
            }
            return this.ns.get(string);
        }

        public Iterator<String> iteratePrefixes() {
            Vector<String> vector = new Vector<String>();
            for (String string : this.ns.keySet()) {
                vector.add(string);
            }
            return vector.iterator();
        }
    }
}

