/* Generated by re2c */
#line 1 "c/fill/01_fill.re"
// re2c $INPUT -o $OUTPUT
#include <assert.h>
#include <stdio.h>
#include <string.h>

#define BUFSIZE 4095

struct Input {
    FILE *file;
    char buf[BUFSIZE + 1], *lim, *cur, *mar, *tok; // +1 for sentinel
    bool eof;
};

static int fill(Input &in) {
    if (in.eof) return 1;

    const size_t shift = in.tok - in.buf;
    const size_t used = in.lim - in.tok;

    // Error: lexeme too long. In real life could reallocate a larger buffer.
    if (shift < 1) return 2;

    // Shift buffer contents (discard everything up to the current token).
    memmove(in.buf, in.tok, used);
    in.lim -= shift;
    in.cur -= shift;
    in.mar -= shift;
    in.tok -= shift;

    // Fill free space at the end of buffer with new data from file.
    in.lim += fread(in.lim, 1, BUFSIZE - used, in.file);
    in.lim[0] = 0;
    in.eof = in.lim < in.buf + BUFSIZE;
    return 0;
}

static int lex(Input &in) {
    int count = 0;
    for (;;) {
        in.tok = in.cur;
    
#line 45 "c/fill/01_fill.c"
{
	char yych;
yyFillLabel0:
	yych = *in.cur;
	switch (yych) {
		case ' ': goto yy3;
		case '\'': goto yy5;
		default:
			if (in.lim <= in.cur) {
				if (fill(in) == 0) goto yyFillLabel0;
				goto yy10;
			}
			goto yy1;
	}
yy1:
	++in.cur;
yy2:
#line 52 "c/fill/01_fill.re"
	{ return -1; }
#line 65 "c/fill/01_fill.c"
yy3:
	++in.cur;
yyFillLabel1:
	yych = *in.cur;
	switch (yych) {
		case ' ': goto yy3;
		default:
			if (in.lim <= in.cur) {
				if (fill(in) == 0) goto yyFillLabel1;
			}
			goto yy4;
	}
yy4:
#line 55 "c/fill/01_fill.re"
	{ continue; }
#line 81 "c/fill/01_fill.c"
yy5:
	in.mar = ++in.cur;
yyFillLabel2:
	yych = *in.cur;
	if (yych >= 0x01) goto yy7;
	if (in.lim <= in.cur) {
		if (fill(in) == 0) goto yyFillLabel2;
		goto yy2;
	}
yy6:
	++in.cur;
yyFillLabel3:
	yych = *in.cur;
yy7:
	switch (yych) {
		case '\'': goto yy8;
		case '\\': goto yy9;
		default:
			if (in.lim <= in.cur) {
				if (fill(in) == 0) goto yyFillLabel3;
				goto yy11;
			}
			goto yy6;
	}
yy8:
	++in.cur;
#line 54 "c/fill/01_fill.re"
	{ ++count; continue; }
#line 110 "c/fill/01_fill.c"
yy9:
	++in.cur;
yyFillLabel4:
	yych = *in.cur;
	if (yych <= 0x00) {
		if (in.lim <= in.cur) {
			if (fill(in) == 0) goto yyFillLabel4;
			goto yy11;
		}
		goto yy6;
	}
	goto yy6;
yy10:
#line 53 "c/fill/01_fill.re"
	{ return count; }
#line 126 "c/fill/01_fill.c"
yy11:
	in.cur = in.mar;
	goto yy2;
}
#line 56 "c/fill/01_fill.re"

    }
}

int main() {
    const char *fname = "input";
    const char content[] = "'qu\0tes' 'are' 'fine: \\'' ";

    // Prepare input file: a few times the size of the buffer, containing
    // strings with zeroes and escaped quotes.
    FILE *f = fopen(fname, "w");
    for (int i = 0; i < BUFSIZE; ++i) {
        fwrite(content, 1, sizeof(content) - 1, f);
    }
    fclose(f);
    int count = 3 * BUFSIZE; // number of quoted strings written to file

    // Initialize lexer state: all pointers are at the end of buffer.
    Input in;
    in.file = fopen(fname, "r");
    in.cur = in.mar = in.tok = in.lim = in.buf + BUFSIZE;
    in.eof = 0;
    // Sentinel (at YYLIMIT pointer) is set to zero, which triggers YYFILL.
    in.lim[0] = 0;

    // Run the lexer.
    assert(lex(in) == count);

    // Cleanup: remove input file.
    fclose(in.file);
    remove(fname);
    return 0;
}
