;; Scheduling description for z14.
;;   Copyright (C) 2019-2026 Free Software Foundation, Inc.
;;   Contributed by Robin Dapp (rdapp@linux.ibm.com)

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 3, or (at your option) any later
;; version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_attr "z14_unit_fpd" ""
(cond [(eq_attr "mnemonic" "ddb,ddbr,deb,debr,dxbr,sqdb,sqdbr,sqeb,\
sqebr,sqxbr,vfddb,vfdsb,vfsqdb,vfsqsb,wfddb,wfdsb,wfdxb,wfsqdb,wfsqxb")
 (const_int 1)] (const_int 0)))

(define_attr "z14_unit_fxa" ""
(cond [(eq_attr "mnemonic" "a,afi,ag,agf,agfi,agfr,agh,aghi,aghik,\
agr,agrk,ahi,ahik,al,alc,alcg,alcgr,alcr,alfi,alg,algf,algfi,algfr,\
alghsik,algr,alhsik,alr,alrk,aly,ark,ay,bras,brasl,etnd,exrl,flogr,ic,icm,\
icmh,icmy,icy,iihf,iilf,ipm,la,larl,lay,lb,lbr,lcgr,lcr,lgb,lgbr,lgf,lgfi,\
lgfr,lgfrl,lgh,lghi,lghr,lghrl,lgr,lh,lhi,lhr,lhrl,lhy,llcr,llgfr,llghr,\
llgtr,llhr,llihf,llihh,llihl,llilf,llilh,llill,lngr,lnr,loc,locg,locghi,\
locgr,lochi,locr,lpgr,lpr,lr,lrv,lrvg,lrvgr,lrvh,lrvr,lt,ltg,ltgf,ltgfr,\
ltgr,ltr,m,mfy,mg,mgh,mghi,mgrk,mh,mhi,mhy,ml,mlg,mlgr,mlr,mr,ms,msfi,msg,\
msgf,msgfi,msgfr,msgr,msgrkc,msr,msrkc,msy,n,ng,ngr,ngrk,nihf,nihh,nihl,\
nilf,nilh,nill,nr,nrk,ny,o,og,ogr,ogrk,oihf,oihh,oihl,oilf,oilh,oill,or,\
ork,oy,pfpo,popcnt,risbg,risbgn,rll,rllg,s,sg,sgf,sgfr,sgh,sgr,sgrk,sh,\
shy,sl,slb,slbg,slbgr,slbr,slfi,slg,slgf,slgfi,slgfr,slgr,slgrk,sll,sllg,\
sllk,slr,slrk,sly,sr,sra,srag,srak,srl,srlg,srlk,sy,x,xg,xgr,xgrk,xihf,\
xilf,xr,xrk,xy")
 (const_int 1)] (const_int 0)))

(define_attr "z14_unit_fxb" ""
(cond [(eq_attr "mnemonic" "agsi,algsi,alsi,asi,b,bc,bcr,bi,br,brcl,\
c,cfi,cg,cgf,cgfi,cgfr,cgfrl,cgh,cghi,cghrl,cghsi,cgit,cgr,cgrl,cgrt,ch,\
chi,chrl,chsi,chy,cit,cl,clfhsi,clfi,clfit,clg,clgf,clgfi,clgfr,clgfrl,\
clghsi,clgit,clgr,clgrl,clgrt,clgt,clhhsi,clhrl,cli,cliy,clm,clmy,clr,clrl,\
clrt,clt,cly,cr,crl,crt,cy,j,jg,laa,laag,lan,lang,lao,laog,lat,lax,laxg,\
lcdfr,ldgr,ldr,lgat,lgdr,lndfr,lpdfr,lzdr,lzer,mvghi,mvhhi,mvhi,mvi,mviy,ni,\
niy,nop,nopr,ntstg,oi,oiy,ppa,st,stc,stcy,std,stdy,ste,stey,stg,stgrl,sth,\
sthrl,sthy,stoc,stocg,strl,strv,strvg,strvh,sty,tend,tm,tmh,tmhh,tmhl,tml,\
tmlh,tmll,tmy,vlgvf,vlgvg,vlgvh,vlr,vlvgb,vlvgf,vlvgg,vlvgh,vlvgp,vst,vstl,\
vstrl,vstrlr,xi,xiy")
 (const_int 1)] (const_int 0)))

(define_attr "z14_unit_fxd" ""
(cond [(eq_attr "mnemonic" "dlgr,dlr,dr,dsgfr,dsgr")
 (const_int 1)] (const_int 0)))

(define_attr "z14_unit_lsu" ""
(cond [(eq_attr "mnemonic" "a,adb,aeb,ag,agf,agh,agsi,al,alc,alcg,\
alg,algf,algsi,alsi,aly,asi,ay,c,cdb,cg,cgf,cgfrl,cgh,cghrl,cghsi,cgrl,ch,\
chrl,chsi,chy,cl,clc,clfhsi,clg,clgf,clgfrl,clghsi,clgrl,clgt,clhhsi,clhrl,\
cli,cliy,clm,clmy,clrl,clt,cly,crl,cy,ddb,deb,ear,ic,icm,icmh,icmy,icy,l,\
laa,laag,lan,lang,lao,laog,lat,lax,laxg,lb,lcbb,ld,lde,ldeb,ldy,le,ley,lg,\
lgat,lgb,lgf,lgfrl,lgh,lghrl,lgrl,lh,lhrl,lhy,llc,llgc,llgf,llgfrl,llgh,\
llghrl,llgt,llh,llhrl,loc,locg,lrl,lrv,lrvg,lrvh,lt,ltg,ltgf,ly,m,madb,maeb,\
meeb,mfy,mg,mgh,mh,mhy,ml,mlg,ms,msdb,mseb,msg,msgf,msy,mvghi,mvhhi,mvhi,\
mvi,mviy,n,ng,ni,niy,ntstg,ny,o,og,oi,oiy,oy,s,sar,sdb,seb,sfpc,sg,sgf,\
sgh,sh,shy,sl,slb,slbg,slg,slgf,sly,sqdb,sqeb,st,stc,stcy,std,stdy,ste,\
stey,stg,stgrl,sth,sthrl,sthy,stoc,stocg,strl,strv,strvg,strvh,sty,sy,\
tabort,tm,tmy,vl,vlbb,vleb,vlef,vleg,vleh,vll,vllezb,vllezf,vllezg,vllezh,\
vllezlf,vlrepb,vlrepf,vlrepg,vlreph,vlrl,vlrlr,vst,vstl,vstrl,vstrlr,x,xg,xi,\
xiy,xy,kdb")
 (const_int 1)] (const_int 0)))

(define_attr "z14_unit_vfu" ""
(cond [(eq_attr "mnemonic" "adb,adbr,adtr,aeb,aebr,axbr,axtr,cdb,\
cdbr,cdtr,cebr,cpsdr,cxbr,cxtr,ddtr,dxtr,fidbr,fidbra,fidtr,fiebr,fiebra,\
fixbr,fixbra,fixtr,lcdbr,lcebr,lcxbr,ldeb,ldebr,ldetr,le,ledbr,ledtr,ler,\
ley,lndbr,lnebr,lnxbr,lpdbr,lpebr,lpxbr,ltdbr,ltebr,ltxbr,ltxtr,lxdb,\
lxdbr,lxdtr,lxeb,lxebr,madb,madbr,maeb,maebr,mdbr,mdtr,meeb,meebr,msdb,\
msdbr,mseb,msebr,mxbr,mxtr,sdb,sdbr,sdtr,seb,sebr,sxbr,sxtr,tcdb,tceb,tcxb,\
tdcdt,tdcet,tdcxt,vab,vaccb,vacccq,vaccf,vaccg,vacch,vaccq,vacq,vaf,vag,vah,\
vaq,vavgb,vavgf,vavgg,vavgh,vavglb,vavglf,vavglg,vavglh,vbperm,vcdgb,\
vcdlgb,vceqb,vceqbs,vceqf,vceqfs,vceqg,vceqgs,vceqh,vceqhs,vcgdb,vchb,vchbs,\
vchf,vchfs,vchg,vchgs,vchh,vchhs,vchlb,vchlbs,vchlf,vchlfs,vchlg,vchlgs,\
vchlh,vchlhs,vcksm,vclgdb,vclzf,vctzb,vctzf,vctzg,vctzh,verimb,verimf,\
verimg,verimh,verllb,verllf,verllg,verllh,verllvb,verllvf,verllvg,verllvh,\
veslb,veslf,veslg,veslh,veslvb,veslvf,veslvg,veslvh,vesrab,vesraf,vesrag,\
vesrah,vesravb,vesravf,vesravg,vesravh,vesrlb,vesrlf,vesrlg,vesrlh,vesrlvb,\
vesrlvf,vesrlvg,vesrlvh,vfadb,vfasb,vfcedb,vfcedbs,vfcesb,vfcesbs,vfchdb,\
vfchdbs,vfchedb,vfchedbs,vfchesb,vfchesbs,vfchsb,vfchsbs,vfeeb,vfeef,vfeeh,\
vfeezbs,vfeezhs,vfeneb,vfenef,vfeneh,vfenezb,vfenezf,vfenezh,vfidb,vfisb,\
vflcdb,vflcsb,vflndb,vflnsb,vflpdb,vfmadb,vfmasb,vfmaxdb,vfmaxsb,vfmdb,\
vfmindb,vfminsb,vfmsb,vfmsdb,vfmssb,vfnmadb,vfnmsdb,vfnmssb,vfsdb,vfssb,\
vftcidb,vftcisb,vgbm,vgfmab,vgfmaf,vgfmag,vgfmah,vgfmb,vgfmf,vgfmg,vgfmh,vgm,\
vistrb,vistrbs,vistrf,vistrfs,vistrh,vlcb,vlcf,vlcg,\
vlch,vldeb,vleb,vledb,vlef,vleg,vleh,vleib,vleif,vleig,vleih,vlpb,vlpf,\
vlpg,vlph,vmaeb,vmaef,vmaeh,vmahb,vmahf,vmahh,vmalb,vmaleb,vmalef,vmaleh,\
vmalf,vmalhb,vmalhf,vmalhh,vmalhw,vmalob,vmalof,vmaloh,vmaob,vmaof,vmaoh,\
vmeb,vmef,vmeh,vmhb,vmhf,vmhh,vmlb,vmleb,vmlef,vmleh,vmlf,vmlhb,vmlhf,\
vmlhh,vmlhw,vmlob,vmlof,vmloh,vmnb,vmnf,vmng,vmnh,vmnlb,vmnlf,vmnlg,vmnlh,\
vmob,vmof,vmoh,vmrhb,vmrhf,vmrhg,vmrhh,vmrlb,vmrlf,vmrlg,vmrlh,vmxb,vmxf,\
vmxg,vmxh,vn,vnc,vnn,vno,vnot,vnx,vo,voc,vone,vpdi,vperm,vpkf,vpkg,vpkh,\
vpklsf,vpklsfs,vpklsg,vpklsgs,vpklsh,vpklshs,vpksf,vpksfs,vpksg,vpksgs,vpksh,\
vpkshs,vpopct,vpopctb,vpopctf,vpopctg,vpopcth,vrepb,vrepf,vrepg,vreph,vrepib,\
vrepif,vrepig,vrepih,vsb,vsbiq,vscbib,vscbif,vscbig,vscbih,vscbiq,vsegb,\
vsegf,vsegh,vsel,vsf,vsg,vsh,vsl,vslb,vsldb,vsq,vsra,vsrab,vsrl,vsrlb,vsumb,\
vsumgf,vsumgh,vsumh,vsumqf,vsumqg,vtm,vuphb,vuphf,vuphh,vuplb,vuplf,vuplhb,\
vuplhf,vuplhh,vuplhw,vupllb,vupllf,vupllh,vx,vzero,wcdgb,wcdlgb,wcgdb,wclgdb,\
wfadb,wfasb,wfaxb,wfcdb,wfcedb,wfcesb,wfcexbs,wfchdb,wfchedb,wfchesb,\
wfchexb,wfchexbs,wfchsb,wfchxb,wfchxbs,wfcsb,wfisb,wfixb,wflcdb,wflcsb,wflcxb,\
wflld,wflndb,wflnsb,wflnxb,wflpdb,wflpsb,wflpxb,wfmadb,wfmasb,wfmaxb,\
wfmaxxb,wfmdb,wfminxb,wfmsb,wfmsdb,wfmssb,wfmsxb,wfmxb,wfnmaxb,wfnmsxb,wfsdb,\
wfssb,wfsxb,wldeb,wledb,kebr,kdb,kdbr,kxbr,kdtr,kxtr,wfkdb,wfksb,vfkesb,\
vfkedb,vfkhsb,vfkhdb,wfkhxb,vfkhesb,vfkhedb,wfkhexb")
 (const_int 1)] (const_int 0)))

(define_attr "z14_cracked" ""
(cond [(eq_attr "mnemonic" "bas,basr,cdfbr,cdftr,cdgbr,cdgtr,cdlfbr,\
cdlftr,cdlgbr,cdlgtr,cefbr,cegbr,celfbr,celgbr,cfdbr,cfebr,cfxbr,cgdbr,cgdtr,\
cgebr,cgxbr,cgxtr,chhsi,clfdbr,clfebr,clfxbr,clfxtr,clgdbr,clgdtr,clgebr,\
clgxbr,clgxtr,cs,csg,csy,d,efpc,ex,lcgfr,lngfr,lpgfr,lpq,lxr,lzxr,rxsbg,stpq,\
vgef,vgeg,vscef,vsceg,vsteb")
 (const_int 1)] (const_int 0)))

(define_attr "z14_expanded" ""
(cond [(eq_attr "mnemonic" "cds,cdsg,cdsy,cxfbr,cxftr,cxgbr,cxgtr,\
cxlftr,cxlgbr,cxlgtr,dl,dlg,dsg,dsgf,lam,lm,lmg,lmy,sldl,srda,srdl,stam,stm,\
stmg,stmy,tbegin,tbeginc")
 (const_int 1)] (const_int 0)))

(define_attr "z14_groupalone" ""
(cond [(eq_attr "mnemonic" "alc,alcg,alcgr,alcr,axbr,axtr,clc,cxbr,\
cxtr,dlgr,dlr,dr,dsgfr,dsgr,dxbr,dxtr,fixbr,fixbra,fixtr,flogr,lcxbr,lnxbr,\
lpxbr,ltxbr,ltxtr,lxdb,lxdbr,lxdtr,lxeb,lxebr,m,madb,maeb,maebr,mfy,mg,mgrk,\
ml,mlg,mlgr,mlr,mr,msdb,mseb,msebr,mvc,mxbr,mxtr,oc,ppa,sfpc,slb,slbg,\
slbgr,slbr,sqxbr,sxbr,sxtr,tabort,tcxb,tdcxt,tend,xc,kxbr,kxtr")
 (const_int 1)] (const_int 0)))

(define_attr "z14_endgroup" ""
(cond [(eq_attr "mnemonic" "bras,brasl,exrl,ipm")
 (const_int 1)] (const_int 0)))

(define_attr "z14_groupoftwo" ""
(cond [(eq_attr "mnemonic" "vacccq,vacq,vfmadb,vfmasb,vfmsdb,vfmssb,\
vfnmadb,vfnmsdb,vfnmssb,vgfmab,vgfmaf,vgfmag,vgfmah,vmaeb,vmaef,vmaeh,vmahb,\
vmahf,vmahh,vmalb,vmaleb,vmalef,vmaleh,vmalf,vmalhb,vmalhf,vmalhh,vmalhw,\
vmalob,vmalof,vmaloh,vmaob,vmaof,vmaoh,vperm,vsbiq,vsel,wfmadb,wfmasb,wfmaxb,\
wfmsdb,wfmssb,wfmsxb,wfnmaxb,wfnmsxb")
 (const_int 1)] (const_int 0)))

(define_insn_reservation "z14_0" 0
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "a,afi,ag,agfi,aghi,aghik,agr,agrk,ahi,ahik,al,\
alfi,alg,algf,algfi,algfr,alghsik,algr,alhsik,alr,alrk,aly,ark,ay,b,bc,bcr,\
bi,br,bras,brasl,brcl,c,cfi,cg,cgfi,cghi,cghsi,cgit,cgr,cgrl,cgrt,chi,\
chsi,cit,cl,clfhsi,clfi,clfit,clg,clgf,clgfi,clgfr,clgfrl,clghsi,clgit,\
clgr,clgrl,clgrt,clgt,clhhsi,clhrl,cli,cliy,clr,clrl,clrt,clt,cly,cr,crl,\
crt,cy,etnd,exrl,ic,icm,icmh,icmy,icy,iihf,iilf,j,jg,la,larl,lat,lay,lb,\
lbr,lcdfr,lcgr,lcr,ldgr,ldr,lgat,lgb,lgbr,lgf,lgfi,lgfr,lgfrl,lgh,lghi,\
lghr,lghrl,lgr,lh,lhi,lhr,lhrl,lhy,llcr,llgfr,llghr,llgtr,llhr,llihf,llihh,\
llihl,llilf,llilh,llill,lndfr,lngr,lnr,lpdfr,lpgr,lpr,lr,lrv,lrvg,lrvgr,\
lrvh,lrvr,lt,ltg,ltgf,ltgfr,ltgr,ltr,lzdr,lzer,n,ng,ngr,ngrk,nihf,nihh,\
nihl,nilf,nilh,nill,nop,nopr,nr,nrk,ny,o,og,ogr,ogrk,oihf,oihh,oihl,oilf,\
oilh,oill,or,ork,oy,pfpo,risbg,risbgn,rll,rllg,rnsbg,rosbg,s,sg,sgr,sgrk,\
sl,sldl,slfi,slg,slgf,slgfi,slgfr,slgr,slgrk,sll,sllg,sllk,slr,slrk,sly,\
sr,sra,srag,srak,srda,srdl,srl,srlg,srlk,sy,tm,tmh,tmhh,tmhl,tml,tmlh,\
tmll,tmy,vlr,vlvgb,vlvgf,vlvgg,vlvgh,x,xg,xgr,xgrk,xihf,xilf,xr,xrk,xy")) "nothing")

(define_insn_reservation "z14_1" 1
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "agf,agfr,agh,agsi,algsi,alsi,asi,cgf,cgfr,cgfrl,\
cgh,cghrl,ch,chrl,chy,clm,clmy,cpsdr,laa,laag,lan,lang,lao,laog,lax,laxg,\
le,ler,ley,loc,locg,locghi,locgr,lochi,locr,mvghi,mvhhi,mvhi,mvi,mviy,ni,\
niy,ntstg,oi,oiy,sgf,sgfr,sgh,sh,shy,st,stc,stcy,stg,stgrl,sth,sthrl,sthy,\
stoc,stocg,strl,strv,strvg,strvh,sty,vab,vaccb,vacccq,vaccf,vaccg,vacch,\
vaccq,vacq,vaf,vag,vah,vaq,vavgb,vavgf,vavgg,vavgh,vavglb,vavglf,vavglg,\
vavglh,vbperm,vceqb,vceqf,vceqg,vceqh,vchb,vchf,vchg,vchh,vchlb,vchlf,vchlg,\
vchlh,vclzf,vctzb,vctzf,vctzg,vctzh,verimb,verimf,verimg,verimh,verllb,\
verllf,verllg,verllh,verllvb,verllvf,verllvg,verllvh,veslb,veslf,veslg,veslh,\
veslvb,veslvf,veslvg,veslvh,vesrab,vesraf,vesrag,vesrah,vesravb,vesravf,\
vesravg,vesravh,vesrlb,vesrlf,vesrlg,vesrlh,vesrlvb,vesrlvf,vesrlvg,vesrlvh,\
vfcedb,vfcesb,vfchdb,vfchedb,vfchesb,vfchsb,vflcdb,vflcsb,vflndb,vflnsb,\
vflpdb,vfmaxdb,vfmaxsb,vfmindb,vfminsb,vgbm,vgm,vlcb,\
vlcf,vlcg,vlch,vleb,vlef,vleg,vleh,vleib,vleif,vleig,vleih,vlpb,vlpf,vlpg,\
vlph,vmnb,vmnf,vmng,vmnh,vmnlb,vmnlf,vmnlg,vmnlh,vmrhb,vmrhf,vmrhg,vmrhh,\
vmrlb,vmrlf,vmrlg,vmrlh,vmxb,vmxf,vmxg,vmxh,vn,vnc,vnn,vno,vnot,vnx,vo,voc,\
vone,vpdi,vperm,vpkf,vpkg,vpkh,vpklsf,vpklsg,vpklsh,vpksf,vpksg,vpksh,\
vpopct,vpopctb,vpopctf,vpopctg,vpopcth,vrepb,vrepf,vrepg,vreph,vrepib,vrepif,\
vrepig,vrepih,vsb,vsbiq,vscbib,vscbif,vscbig,vscbih,vscbiq,vsegb,vsegf,vsegh,\
vsel,vsf,vsg,vsh,vsl,vslb,vsldb,vsq,vsra,vsrab,vsrl,vsrlb,vuphb,vuphf,\
vuphh,vuplb,vuplf,vuplhb,vuplhf,vuplhh,vuplhw,vupllb,vupllf,vupllh,vx,vzero,\
wfcedb,wfcesb,wfchdb,wfchedb,wfchesb,wfchexb,wfchsb,wfchxb,wflcdb,wflcsb,\
wflcxb,wflndb,wflnsb,wflnxb,wflpdb,wflpsb,wflpxb,wfmaxxb,wfminxb,xi,xiy,\
vfkesb,vfkedb,vfkhsb,vfkhdb,wfkhxb,vfkhesb,vfkhedb,wfkhexb")) "nothing")

(define_insn_reservation "z14_2" 2
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "cdb,cdbr,cebr,ear,ipm,l,lcbb,lcdbr,lcebr,ld,lde,\
ldy,lg,lgdr,lgrl,llc,llgc,llgf,llgfrl,llgh,llghrl,llgt,llh,llhrl,lm,lmg,\
lmy,lndbr,lnebr,lpdbr,lpebr,lrl,ltdbr,ltebr,ly,popcnt,sar,tcdb,tceb,\
vceqbs,vceqfs,vceqgs,vceqhs,vchbs,vchfs,vchgs,vchhs,vchlbs,vchlfs,vchlgs,\
vchlhs,vfcedbs,vfcesbs,vfchdbs,vfchedbs,vfchesbs,vfchsbs,vfeeb,vfeef,vfeeh,\
vfeneb,vfenef,vfeneh,vfenezb,vfenezf,vfenezh,vftcidb,vftcisb,vistrb,vistrf,\
vistrh,vlgvf,vlgvg,vlgvh,vllezb,vllezf,vllezg,vllezh,vllezlf,vlrepb,vlrepf,\
vlrepg,vlreph,vlrl,vlvgp,vpklsfs,vpklsgs,vpklshs,vpksfs,vpksgs,vpkshs,wfcdb,\
wfcexbs,wfchexbs,wfchxbs,wfcsb,kebr,kdb,kdbr,wfkdb,wfksb")) "nothing")

(define_insn_reservation "z14_3" 3
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "cds,cdsy,mgh,mghi,mh,mhi,mhy,std,stdy,ste,stey,\
vcksm,vfeezbs,vfeezhs,vgfmab,vgfmaf,vgfmag,vgfmah,vgfmb,vgfmf,vgfmg,vgfmh,\
vistrbs,vistrfs,vl,vlbb,vll,vlrlr,vmaeb,vmaef,vmaeh,vmahb,vmahf,vmahh,vmalb,\
vmaleb,vmalef,vmaleh,vmalf,vmalhb,vmalhf,vmalhh,vmalhw,vmalob,vmalof,vmaloh,\
vmaob,vmaof,vmaoh,vmeb,vmef,vmeh,vmhb,vmhf,vmhh,vmlb,vmleb,vmlef,vmleh,vmlf,\
vmlhb,vmlhf,vmlhh,vmlhw,vmlob,vmlof,vmloh,vmob,vmof,vmoh,vsumb,vsumgf,\
vsumgh,vsumh,vsumqf,vsumqg,vtm")) "nothing")

(define_insn_reservation "z14_4" 4
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "bas,basr,chhsi,clc,ex,lam,lcgfr,lngfr,lpgfr,lxr,\
lzxr,ms,msfi,msgf,msgfi,msgfr,msr,msy,mvc,oc,ppa,rxsbg,tabort,tbegin,\
tbeginc,tend,vst,vstl,vstrl,vstrlr,xc")) "nothing")

(define_insn_reservation "z14_5" 5
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "alc,alcg,alcgr,alcr,cs,csg,csy,msrkc,slb,slbg,\
slbgr,slbr,stm,stmg,stmy")) "nothing")

(define_insn_reservation "z14_6" 6
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "adb,adbr,aeb,aebr,fidbr,fidbra,fiebr,fiebra,\
ldeb,ldebr,ledbr,madbr,mdbr,meeb,meebr,msdbr,msg,msgr,sdb,sdbr,seb,sebr,\
sfpc,vcdgb,vcdlgb,vcgdb,vclgdb,vfadb,vfidb,vfmadb,vfmdb,vfmsdb,vfnmadb,\
vfnmsdb,vfsdb,vldeb,vledb,wcdgb,wcdlgb,wcgdb,wclgdb,wfadb,wfasb,wfisb,wfmadb,\
wfmasb,wfmdb,wfmsb,wfmsdb,wfmssb,wfsdb,wfssb,wldeb,wledb")) "nothing")

(define_insn_reservation "z14_7" 7
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "adtr,cdtr,fidtr,ldetr,msgrkc,sdtr,tdcdt,tdcet,\
vfasb,vfisb,vfmasb,vfmsb,vfmssb,vfnmssb,vfssb,vgef,vgeg,wflld,kdtr"))
"nothing")

(define_insn_reservation "z14_8" 8
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "cdsg,flogr,lpq,stpq,vsteb")) "nothing")

(define_insn_reservation "z14_9" 9
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "cxfbr,cxgbr,cxlgbr,m,mfy,ml,mlr,mr,stam,wfaxb,\
wfixb,wfsxb")) "nothing")

(define_insn_reservation "z14_10" 10
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "cdfbr,cdgbr,cdlfbr,cdlgbr,cefbr,cegbr,celfbr,\
celgbr,madb,maeb,maebr,msdb,mseb,msebr,vscef,vsceg")) "nothing")

(define_insn_reservation "z14_11" 11
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "lxdb,lxdbr,lxeb,lxebr,mg,mgrk,mlg,mlgr")) "nothing")

(define_insn_reservation "z14_12" 12
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "cfdbr,cfebr,cgdbr,cgebr,clfdbr,clfebr,clgdbr,\
clgebr,cxbr,cxtr,tcxb,tdcxt,kxbr,kxtr")) "nothing")

(define_insn_reservation "z14_13" 13
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "axbr,axtr,fixbr,fixbra,fixtr,lcxbr,lnxbr,lpxbr,\
ltxbr,ltxtr,lxdtr,sxbr,sxtr")) "nothing")

(define_insn_reservation "z14_14" 14
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "cfxbr,cgxbr,clfxbr,clgxbr,ledtr")) "nothing")

(define_insn_reservation "z14_20" 20
  (and (eq_attr "cpu" "z14")
(eq_attr "mnemonic" "cdftr,cdgtr,cdlftr,cdlgtr,cgdtr,cgxtr,clfxtr,\
clgdtr,clgxtr,cxftr,cxgtr,cxlftr,cxlgtr,d,ddb,ddbr,ddtr,deb,debr,dl,dlg,dlgr,\
dlr,dr,dsg,dsgf,dsgfr,dsgr,dxbr,dxtr,efpc,mdtr,mxbr,mxtr,sqdb,sqdbr,sqeb,\
sqebr,sqxbr,vfddb,vfdsb,vfsqdb,vfsqsb,wfddb,wfdsb,wfdxb,wfmaxb,wfmsxb,wfmxb,\
wfnmaxb,wfnmsxb,wfsqdb,wfsqxb")) "nothing")

