/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct RentalVehicleType {
    /// Unique identifier of the vehicle type (unique within the provider)
    #[serde(rename = "id")]
    pub id: String,
    /// Public name of the vehicle type (can be empty)
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "formFactor")]
    pub form_factor: models::RentalFormFactor,
    #[serde(rename = "propulsionType")]
    pub propulsion_type: models::RentalPropulsionType,
    #[serde(rename = "returnConstraint")]
    pub return_constraint: models::RentalReturnConstraint,
    /// Whether the return constraint was guessed instead of being specified by the rental provider
    #[serde(rename = "returnConstraintGuessed")]
    pub return_constraint_guessed: bool,
}

impl RentalVehicleType {
    pub fn new(id: String, form_factor: models::RentalFormFactor, propulsion_type: models::RentalPropulsionType, return_constraint: models::RentalReturnConstraint, return_constraint_guessed: bool) -> RentalVehicleType {
        RentalVehicleType {
            id,
            name: None,
            form_factor,
            propulsion_type,
            return_constraint,
            return_constraint_guessed,
        }
    }
}

