// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct GetAsyncInvokeOutput {
    /// <p>The invocation's ARN.</p>
    pub invocation_arn: ::std::string::String,
    /// <p>The invocation's model ARN.</p>
    pub model_arn: ::std::string::String,
    /// <p>The invocation's idempotency token.</p>
    pub client_request_token: ::std::option::Option<::std::string::String>,
    /// <p>The invocation's status.</p>
    pub status: crate::types::AsyncInvokeStatus,
    /// <p>An error message.</p>
    pub failure_message: ::std::option::Option<::std::string::String>,
    /// <p>When the invocation request was submitted.</p>
    pub submit_time: ::aws_smithy_types::DateTime,
    /// <p>The invocation's last modified time.</p>
    pub last_modified_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>When the invocation ended.</p>
    pub end_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>Output data settings.</p>
    pub output_data_config: ::std::option::Option<crate::types::AsyncInvokeOutputDataConfig>,
    _request_id: Option<String>,
}
impl GetAsyncInvokeOutput {
    /// <p>The invocation's ARN.</p>
    pub fn invocation_arn(&self) -> &str {
        use std::ops::Deref;
        self.invocation_arn.deref()
    }
    /// <p>The invocation's model ARN.</p>
    pub fn model_arn(&self) -> &str {
        use std::ops::Deref;
        self.model_arn.deref()
    }
    /// <p>The invocation's idempotency token.</p>
    pub fn client_request_token(&self) -> ::std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The invocation's status.</p>
    pub fn status(&self) -> &crate::types::AsyncInvokeStatus {
        &self.status
    }
    /// <p>An error message.</p>
    pub fn failure_message(&self) -> ::std::option::Option<&str> {
        self.failure_message.as_deref()
    }
    /// <p>When the invocation request was submitted.</p>
    pub fn submit_time(&self) -> &::aws_smithy_types::DateTime {
        &self.submit_time
    }
    /// <p>The invocation's last modified time.</p>
    pub fn last_modified_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>When the invocation ended.</p>
    pub fn end_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Output data settings.</p>
    pub fn output_data_config(&self) -> ::std::option::Option<&crate::types::AsyncInvokeOutputDataConfig> {
        self.output_data_config.as_ref()
    }
}
impl ::std::fmt::Debug for GetAsyncInvokeOutput {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("GetAsyncInvokeOutput");
        formatter.field("invocation_arn", &self.invocation_arn);
        formatter.field("model_arn", &self.model_arn);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("status", &self.status);
        formatter.field("failure_message", &"*** Sensitive Data Redacted ***");
        formatter.field("submit_time", &self.submit_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("_request_id", &self._request_id);
        formatter.finish()
    }
}
impl ::aws_types::request_id::RequestId for GetAsyncInvokeOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl GetAsyncInvokeOutput {
    /// Creates a new builder-style object to manufacture [`GetAsyncInvokeOutput`](crate::operation::get_async_invoke::GetAsyncInvokeOutput).
    pub fn builder() -> crate::operation::get_async_invoke::builders::GetAsyncInvokeOutputBuilder {
        crate::operation::get_async_invoke::builders::GetAsyncInvokeOutputBuilder::default()
    }
}

/// A builder for [`GetAsyncInvokeOutput`](crate::operation::get_async_invoke::GetAsyncInvokeOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct GetAsyncInvokeOutputBuilder {
    pub(crate) invocation_arn: ::std::option::Option<::std::string::String>,
    pub(crate) model_arn: ::std::option::Option<::std::string::String>,
    pub(crate) client_request_token: ::std::option::Option<::std::string::String>,
    pub(crate) status: ::std::option::Option<crate::types::AsyncInvokeStatus>,
    pub(crate) failure_message: ::std::option::Option<::std::string::String>,
    pub(crate) submit_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) last_modified_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) end_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) output_data_config: ::std::option::Option<crate::types::AsyncInvokeOutputDataConfig>,
    _request_id: Option<String>,
}
impl GetAsyncInvokeOutputBuilder {
    /// <p>The invocation's ARN.</p>
    /// This field is required.
    pub fn invocation_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.invocation_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The invocation's ARN.</p>
    pub fn set_invocation_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.invocation_arn = input;
        self
    }
    /// <p>The invocation's ARN.</p>
    pub fn get_invocation_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.invocation_arn
    }
    /// <p>The invocation's model ARN.</p>
    /// This field is required.
    pub fn model_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.model_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The invocation's model ARN.</p>
    pub fn set_model_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.model_arn = input;
        self
    }
    /// <p>The invocation's model ARN.</p>
    pub fn get_model_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.model_arn
    }
    /// <p>The invocation's idempotency token.</p>
    pub fn client_request_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.client_request_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The invocation's idempotency token.</p>
    pub fn set_client_request_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.client_request_token = input;
        self
    }
    /// <p>The invocation's idempotency token.</p>
    pub fn get_client_request_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.client_request_token
    }
    /// <p>The invocation's status.</p>
    /// This field is required.
    pub fn status(mut self, input: crate::types::AsyncInvokeStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The invocation's status.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::AsyncInvokeStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>The invocation's status.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::AsyncInvokeStatus> {
        &self.status
    }
    /// <p>An error message.</p>
    pub fn failure_message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.failure_message = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An error message.</p>
    pub fn set_failure_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.failure_message = input;
        self
    }
    /// <p>An error message.</p>
    pub fn get_failure_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.failure_message
    }
    /// <p>When the invocation request was submitted.</p>
    /// This field is required.
    pub fn submit_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.submit_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>When the invocation request was submitted.</p>
    pub fn set_submit_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.submit_time = input;
        self
    }
    /// <p>When the invocation request was submitted.</p>
    pub fn get_submit_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.submit_time
    }
    /// <p>The invocation's last modified time.</p>
    pub fn last_modified_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.last_modified_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The invocation's last modified time.</p>
    pub fn set_last_modified_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.last_modified_time = input;
        self
    }
    /// <p>The invocation's last modified time.</p>
    pub fn get_last_modified_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.last_modified_time
    }
    /// <p>When the invocation ended.</p>
    pub fn end_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.end_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>When the invocation ended.</p>
    pub fn set_end_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.end_time = input;
        self
    }
    /// <p>When the invocation ended.</p>
    pub fn get_end_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.end_time
    }
    /// <p>Output data settings.</p>
    /// This field is required.
    pub fn output_data_config(mut self, input: crate::types::AsyncInvokeOutputDataConfig) -> Self {
        self.output_data_config = ::std::option::Option::Some(input);
        self
    }
    /// <p>Output data settings.</p>
    pub fn set_output_data_config(mut self, input: ::std::option::Option<crate::types::AsyncInvokeOutputDataConfig>) -> Self {
        self.output_data_config = input;
        self
    }
    /// <p>Output data settings.</p>
    pub fn get_output_data_config(&self) -> &::std::option::Option<crate::types::AsyncInvokeOutputDataConfig> {
        &self.output_data_config
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`GetAsyncInvokeOutput`](crate::operation::get_async_invoke::GetAsyncInvokeOutput).
    /// This method will fail if any of the following fields are not set:
    /// - [`invocation_arn`](crate::operation::get_async_invoke::builders::GetAsyncInvokeOutputBuilder::invocation_arn)
    /// - [`model_arn`](crate::operation::get_async_invoke::builders::GetAsyncInvokeOutputBuilder::model_arn)
    /// - [`status`](crate::operation::get_async_invoke::builders::GetAsyncInvokeOutputBuilder::status)
    /// - [`submit_time`](crate::operation::get_async_invoke::builders::GetAsyncInvokeOutputBuilder::submit_time)
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::get_async_invoke::GetAsyncInvokeOutput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::get_async_invoke::GetAsyncInvokeOutput {
            invocation_arn: self.invocation_arn.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "invocation_arn",
                    "invocation_arn was not specified but it is required when building GetAsyncInvokeOutput",
                )
            })?,
            model_arn: self.model_arn.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "model_arn",
                    "model_arn was not specified but it is required when building GetAsyncInvokeOutput",
                )
            })?,
            client_request_token: self.client_request_token,
            status: self.status.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "status",
                    "status was not specified but it is required when building GetAsyncInvokeOutput",
                )
            })?,
            failure_message: self.failure_message,
            submit_time: self.submit_time.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "submit_time",
                    "submit_time was not specified but it is required when building GetAsyncInvokeOutput",
                )
            })?,
            last_modified_time: self.last_modified_time,
            end_time: self.end_time,
            output_data_config: self.output_data_config,
            _request_id: self._request_id,
        })
    }
}
impl ::std::fmt::Debug for GetAsyncInvokeOutputBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("GetAsyncInvokeOutputBuilder");
        formatter.field("invocation_arn", &self.invocation_arn);
        formatter.field("model_arn", &self.model_arn);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("status", &self.status);
        formatter.field("failure_message", &"*** Sensitive Data Redacted ***");
        formatter.field("submit_time", &self.submit_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("_request_id", &self._request_id);
        formatter.finish()
    }
}
