//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfpage?language=objc)
#[repr(C)]
pub struct CGPDFPage {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGPDFPage {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGPDFPage"> for CGPDFPage {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfbox?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGPDFBox(pub i32);
impl CGPDFBox {
    #[doc(alias = "kCGPDFMediaBox")]
    pub const MediaBox: Self = Self(0);
    #[doc(alias = "kCGPDFCropBox")]
    pub const CropBox: Self = Self(1);
    #[doc(alias = "kCGPDFBleedBox")]
    pub const BleedBox: Self = Self(2);
    #[doc(alias = "kCGPDFTrimBox")]
    pub const TrimBox: Self = Self(3);
    #[doc(alias = "kCGPDFArtBox")]
    pub const ArtBox: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGPDFBox {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPDFBox {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CGPDFPage {
    #[doc(alias = "CGPDFPageGetDocument")]
    #[cfg(feature = "CGPDFDocument")]
    #[inline]
    pub unsafe fn document(page: Option<&CGPDFPage>) -> Option<CFRetained<CGPDFDocument>> {
        extern "C-unwind" {
            fn CGPDFPageGetDocument(page: Option<&CGPDFPage>) -> Option<NonNull<CGPDFDocument>>;
        }
        let ret = unsafe { CGPDFPageGetDocument(page) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CGPDFPageGetPageNumber")]
    #[inline]
    pub unsafe fn page_number(page: Option<&CGPDFPage>) -> usize {
        extern "C-unwind" {
            fn CGPDFPageGetPageNumber(page: Option<&CGPDFPage>) -> usize;
        }
        unsafe { CGPDFPageGetPageNumber(page) }
    }

    #[doc(alias = "CGPDFPageGetBoxRect")]
    #[inline]
    pub unsafe fn box_rect(page: Option<&CGPDFPage>, r#box: CGPDFBox) -> CGRect {
        extern "C-unwind" {
            fn CGPDFPageGetBoxRect(page: Option<&CGPDFPage>, r#box: CGPDFBox) -> CGRect;
        }
        unsafe { CGPDFPageGetBoxRect(page, r#box) }
    }

    #[doc(alias = "CGPDFPageGetRotationAngle")]
    #[inline]
    pub unsafe fn rotation_angle(page: Option<&CGPDFPage>) -> c_int {
        extern "C-unwind" {
            fn CGPDFPageGetRotationAngle(page: Option<&CGPDFPage>) -> c_int;
        }
        unsafe { CGPDFPageGetRotationAngle(page) }
    }

    #[doc(alias = "CGPDFPageGetDrawingTransform")]
    #[inline]
    pub unsafe fn drawing_transform(
        page: Option<&CGPDFPage>,
        r#box: CGPDFBox,
        rect: CGRect,
        rotate: c_int,
        preserve_aspect_ratio: bool,
    ) -> CGAffineTransform {
        extern "C-unwind" {
            fn CGPDFPageGetDrawingTransform(
                page: Option<&CGPDFPage>,
                r#box: CGPDFBox,
                rect: CGRect,
                rotate: c_int,
                preserve_aspect_ratio: bool,
            ) -> CGAffineTransform;
        }
        unsafe { CGPDFPageGetDrawingTransform(page, r#box, rect, rotate, preserve_aspect_ratio) }
    }

    #[doc(alias = "CGPDFPageGetDictionary")]
    #[cfg(feature = "CGPDFDictionary")]
    #[inline]
    pub unsafe fn dictionary(page: Option<&CGPDFPage>) -> CGPDFDictionaryRef {
        extern "C-unwind" {
            fn CGPDFPageGetDictionary(page: Option<&CGPDFPage>) -> CGPDFDictionaryRef;
        }
        unsafe { CGPDFPageGetDictionary(page) }
    }
}

unsafe impl ConcreteType for CGPDFPage {
    #[doc(alias = "CGPDFPageGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGPDFPageGetTypeID() -> CFTypeID;
        }
        unsafe { CGPDFPageGetTypeID() }
    }
}

#[cfg(feature = "CGPDFDocument")]
#[deprecated = "renamed to `CGPDFPage::document`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPDFPageGetDocument(
    page: Option<&CGPDFPage>,
) -> Option<CFRetained<CGPDFDocument>> {
    extern "C-unwind" {
        fn CGPDFPageGetDocument(page: Option<&CGPDFPage>) -> Option<NonNull<CGPDFDocument>>;
    }
    let ret = unsafe { CGPDFPageGetDocument(page) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFPage::page_number`"]
    pub fn CGPDFPageGetPageNumber(page: Option<&CGPDFPage>) -> usize;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFPage::box_rect`"]
    pub fn CGPDFPageGetBoxRect(page: Option<&CGPDFPage>, r#box: CGPDFBox) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFPage::rotation_angle`"]
    pub fn CGPDFPageGetRotationAngle(page: Option<&CGPDFPage>) -> c_int;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFPage::drawing_transform`"]
    pub fn CGPDFPageGetDrawingTransform(
        page: Option<&CGPDFPage>,
        r#box: CGPDFBox,
        rect: CGRect,
        rotate: c_int,
        preserve_aspect_ratio: bool,
    ) -> CGAffineTransform;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFDictionary")]
    #[deprecated = "renamed to `CGPDFPage::dictionary`"]
    pub fn CGPDFPageGetDictionary(page: Option<&CGPDFPage>) -> CGPDFDictionaryRef;
}
